/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerImpl;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.scope.impl.LuceneIndexScopeImpl;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;

class LuceneIndexScopeBuilder<SR>
implements IndexScopeBuilder<SR> {
    private final IndexManagerBackendContext backendContext;
    private final BackendMappingContext mappingContext;
    private final Class<SR> rootScopeType;
    private final Set<LuceneIndexManagerImpl> indexManagers = new LinkedHashSet<LuceneIndexManagerImpl>();

    LuceneIndexScopeBuilder(IndexManagerBackendContext backendContext, BackendMappingContext mappingContext, Class<SR> rootScopeType, LuceneIndexManagerImpl indexManager) {
        this.backendContext = backendContext;
        this.mappingContext = mappingContext;
        this.rootScopeType = rootScopeType;
        this.indexManagers.add(indexManager);
    }

    void add(IndexManagerBackendContext backendContext, LuceneIndexManagerImpl indexManager) {
        if (!this.backendContext.equals(backendContext)) {
            throw QueryLog.INSTANCE.cannotMixLuceneScopeWithOtherBackend(this, indexManager, backendContext.getEventContext());
        }
        this.indexManagers.add(indexManager);
    }

    public IndexScope<SR> build() {
        return new LuceneIndexScopeImpl<SR>(this.backendContext, this.mappingContext, this.rootScopeType, this.indexManagers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "backendContext=" + this.backendContext + ", indexManagers=" + this.indexManagers + "]";
    }
}

