/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.util.Locale;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.AggregationFunction;

public class CountValues
implements AggregationFunction<CountValues> {
    private long count = 0L;

    @Override
    public void apply(long value) {
        ++this.count;
    }

    @Override
    public void merge(AggregationFunction<CountValues> sibling) {
        this.count += sibling.implementation().count;
    }

    @Override
    public Long result() {
        return this.count;
    }

    @Override
    public CountValues implementation() {
        return this;
    }

    public String toString() {
        return String.format(Locale.ROOT, "CountValues{count=%d}", this.count);
    }
}

