/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.util.Locale;

public class KahanSummation {
    private static final double NO_CORRECTION = 0.0;
    private double value;
    private double delta;
    private boolean initialized;

    public KahanSummation(double value, double delta) {
        this.value = value;
        this.delta = delta;
    }

    public double value() {
        return this.value;
    }

    public double delta() {
        return this.delta;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public KahanSummation add(double value) {
        return this.add(value, 0.0);
    }

    public void reset(double value, double delta) {
        this.value = value;
        this.delta = delta;
    }

    public KahanSummation add(double value, double delta) {
        this.initialized = true;
        if (Double.isFinite(value)) {
            this.value = value + this.value;
        } else {
            double correctedSum = value + (this.delta + delta);
            double updatedValue = this.value + correctedSum;
            this.delta = correctedSum - (updatedValue - this.value);
            this.value = updatedValue;
        }
        return this;
    }

    public String toString() {
        return String.format(Locale.ROOT, "{value=%s, delta=%s, initialized=%s}", this.value, this.delta, this.initialized);
    }
}

