/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.util.Locale;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.AggregationFunction;

public class Min
implements AggregationFunction<Min> {
    private Long min;

    @Override
    public void apply(long value) {
        if (this.min == null) {
            this.min = value;
            return;
        }
        this.min = Math.min(this.min, value);
    }

    @Override
    public void merge(AggregationFunction<Min> sibling) {
        Long other = sibling.implementation().min;
        if (other != null) {
            this.apply(other);
        }
    }

    @Override
    public Long result() {
        return this.min;
    }

    @Override
    public Min implementation() {
        return this;
    }

    public String toString() {
        return String.format(Locale.ROOT, "Min{min=%d}", this.min);
    }
}

