/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.RangeCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.RangeCollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.RangeResults;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.EffectiveRange;

public class RangeCollectorFactory
implements CollectorFactory<RangeCollector, RangeResults, RangeCollectorManager> {
    public final CollectorKey<RangeCollector, RangeResults> key = CollectorKey.create();
    private final LongMultiValuesSource valuesSource;
    private final EffectiveRange[] ranges;
    private final List<CollectorFactory<?, ?, ?>> collectorFactories;

    public static CollectorFactory<RangeCollector, RangeResults, RangeCollectorManager> instance(LongMultiValuesSource valuesSource, EffectiveRange[] ranges, List<CollectorFactory<?, ?, ?>> collectorFactories) {
        return new RangeCollectorFactory(valuesSource, ranges, collectorFactories);
    }

    public RangeCollectorFactory(LongMultiValuesSource valuesSource, EffectiveRange[] ranges, List<CollectorFactory<?, ?, ?>> collectorFactories) {
        this.valuesSource = valuesSource;
        this.ranges = ranges;
        this.collectorFactories = collectorFactories;
    }

    @Override
    public RangeCollectorManager createCollectorManager(CollectorExecutionContext context) throws IOException {
        CollectorKey[] keys = new CollectorKey[this.collectorFactories.size()];
        CollectorManager[] managers = new CollectorManager[this.collectorFactories.size()];
        int index = 0;
        for (CollectorFactory<?, ?, ?> collectorFactory : this.collectorFactories) {
            Object collectorManager = collectorFactory.createCollectorManager(context);
            keys[index] = collectorFactory.getCollectorKey();
            managers[index] = collectorManager;
            ++index;
        }
        return new RangeCollectorManager(this.valuesSource, this.ranges, keys, managers);
    }

    @Override
    public CollectorKey<RangeCollector, RangeResults> getCollectorKey() {
        return this.key;
    }
}

