/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.util.List;
import java.util.Set;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneNestableAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.FieldMetricAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;

public abstract class AbstractLuceneMetricNumericFieldAggregation<F, E extends Number, K>
extends AbstractLuceneNestableAggregation<K> {
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    protected final AbstractLuceneNumericFieldCodec<F, E> codec;
    protected final LuceneNumericDomain<E> numericDomain;
    private final AbstractExtractorBuilder<F, E, K> extractorCreator;

    AbstractLuceneMetricNumericFieldAggregation(Builder<F, E, K> builder) {
        super(builder);
        this.indexNames = builder.scope.hibernateSearchIndexNames();
        this.absoluteFieldPath = builder.field.absolutePath();
        this.codec = builder.codec;
        this.numericDomain = this.codec.getDomain();
        this.extractorCreator = builder.extractorCreator;
    }

    @Override
    public LuceneSearchAggregation.Extractor<K> request(AggregationRequestContext context) {
        JoiningLongMultiValuesSource source = JoiningLongMultiValuesSource.fromField(this.absoluteFieldPath, this.createNestedDocsProvider(context));
        return this.extractorCreator.extractor(this, this.fillCollectors(source, context));
    }

    abstract List<CollectorKey<?, Long>> fillCollectors(JoiningLongMultiValuesSource var1, AggregationRequestContext var2);

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    protected static abstract class Builder<F, E extends Number, K>
    extends AbstractLuceneNestableAggregation.AbstractBuilder<K>
    implements FieldMetricAggregationBuilder<K> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final AbstractExtractorBuilder<F, E, K> extractorCreator;

        public Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, AbstractExtractorBuilder<F, E, K> extractorCreator) {
            super(scope, field);
            this.codec = codec;
            this.extractorCreator = extractorCreator;
        }
    }

    protected static abstract class AbstractExtractorBuilder<F, E extends Number, K> {
        protected AbstractExtractorBuilder() {
        }

        abstract LuceneSearchAggregation.Extractor<K> extractor(AbstractLuceneMetricNumericFieldAggregation<F, E, K> var1, List<CollectorKey<?, Long>> var2);
    }

    protected static abstract class TypeSelector<F, E extends Number>
    implements FieldMetricAggregationBuilder.TypeSelector {
        protected final AbstractLuceneNumericFieldCodec<F, E> codec;
        protected final LuceneSearchIndexScope<?> scope;
        protected final LuceneSearchIndexValueFieldContext<F> field;

        protected TypeSelector(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <T> Builder<F, ?, T> type(Class<T> expectedType, ValueModel valueModel) {
            AbstractExtractorBuilder<F, E, T> extractorCreator;
            if (ValueModel.RAW.equals((Object)valueModel)) {
                if (Double.class.isAssignableFrom(expectedType)) {
                    extractorCreator = this.doubleExtractor();
                } else {
                    ProjectionConverter projectionConverter = this.field.type().rawProjectionConverter().withConvertedType(expectedType, this.field);
                    extractorCreator = this.rawExtractor(projectionConverter);
                }
            } else {
                ProjectionConverter projectionConverter = this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, this.field);
                extractorCreator = this.extractor(projectionConverter);
            }
            return this.getFtBuilder(extractorCreator);
        }

        protected <T> AbstractExtractorBuilder<F, E, T> extractor(ProjectionConverter<F, ? extends T> projectionConverter) {
            return new LuceneNumericMetricFieldAggregationExtraction.Builder(projectionConverter);
        }

        protected <T> AbstractExtractorBuilder<F, E, T> rawExtractor(ProjectionConverter<?, ? extends T> projectionConverter) {
            return new LuceneNumericMetricFieldAggregationRawExtraction.Builder();
        }

        protected <T> AbstractExtractorBuilder<F, E, T> doubleExtractor() {
            return new LuceneNumericMetricFieldAggregationDoubleExtractor.Builder();
        }

        protected abstract <T> Builder<F, E, T> getFtBuilder(AbstractExtractorBuilder<F, E, T> var1);
    }

    private static class LuceneNumericMetricFieldAggregationRawExtraction<E extends Number, K>
    implements LuceneSearchAggregation.Extractor<K> {
        private final CollectorKey<?, Long> collectorKey;
        private final LuceneNumericDomain<E> numericDomain;

        private LuceneNumericMetricFieldAggregationRawExtraction(CollectorKey<?, Long> collectorKey, LuceneNumericDomain<E> numericDomain) {
            this.collectorKey = collectorKey;
            this.numericDomain = numericDomain;
        }

        @Override
        public K extract(AggregationExtractContext context) {
            Long collector = context.getCollectorResults(this.collectorKey);
            return (K)this.numericDomain.sortedDocValueToTerm(collector);
        }

        private static class Builder<F, E extends Number, K>
        extends AbstractExtractorBuilder<F, E, K> {
            private Builder() {
            }

            @Override
            LuceneSearchAggregation.Extractor<K> extractor(AbstractLuceneMetricNumericFieldAggregation<F, E, K> aggregation, List<CollectorKey<?, Long>> collectorKeys) {
                return new LuceneNumericMetricFieldAggregationRawExtraction(collectorKeys.get(0), aggregation.numericDomain);
            }
        }
    }

    private static class LuceneNumericMetricFieldAggregationDoubleExtractor
    implements LuceneSearchAggregation.Extractor<Double> {
        private final CollectorKey<?, Long> collectorKey;
        private final AbstractLuceneNumericFieldCodec<?, ?> codec;

        private LuceneNumericMetricFieldAggregationDoubleExtractor(CollectorKey<?, Long> collectorKey, AbstractLuceneNumericFieldCodec<?, ?> codec) {
            this.collectorKey = collectorKey;
            this.codec = codec;
        }

        @Override
        public Double extract(AggregationExtractContext context) {
            Long collector = context.getCollectorResults(this.collectorKey);
            return this.codec.sortedDocValueToDouble(collector);
        }

        private static class Builder<F, E extends Number>
        extends AbstractExtractorBuilder<F, E, Double> {
            private Builder() {
            }

            @Override
            LuceneSearchAggregation.Extractor<Double> extractor(AbstractLuceneMetricNumericFieldAggregation<F, E, Double> aggregation, List<CollectorKey<?, Long>> collectorKeys) {
                return new LuceneNumericMetricFieldAggregationDoubleExtractor(collectorKeys.get(0), aggregation.codec);
            }
        }
    }

    private static class LuceneNumericMetricFieldAggregationExtraction<F, E extends Number, K>
    implements LuceneSearchAggregation.Extractor<K> {
        private final CollectorKey<?, Long> collectorKey;
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;

        private LuceneNumericMetricFieldAggregationExtraction(CollectorKey<?, Long> collectorKey, AbstractLuceneNumericFieldCodec<F, E> codec, ProjectionConverter<F, ? extends K> fromFieldValueConverter) {
            this.collectorKey = collectorKey;
            this.codec = codec;
            this.fromFieldValueConverter = fromFieldValueConverter;
        }

        @Override
        public K extract(AggregationExtractContext context) {
            Long collector = context.getCollectorResults(this.collectorKey);
            E e = this.codec.getDomain().sortedDocValueToTerm(collector);
            Object decode = this.codec.decode(e);
            return (K)this.fromFieldValueConverter.fromDocumentValue(decode, context.fromDocumentValueConvertContext());
        }

        private static class Builder<F, E extends Number, K>
        extends AbstractExtractorBuilder<F, E, K> {
            private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;

            private Builder(ProjectionConverter<F, ? extends K> fromFieldValueConverter) {
                this.fromFieldValueConverter = fromFieldValueConverter;
            }

            @Override
            LuceneSearchAggregation.Extractor<K> extractor(AbstractLuceneMetricNumericFieldAggregation<F, E, K> aggregation, List<CollectorKey<?, Long>> collectorKeys) {
                return new LuceneNumericMetricFieldAggregationExtraction(collectorKeys.get(0), aggregation.codec, this.fromFieldValueConverter);
            }
        }
    }
}

