/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongHashSet;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CountDistinctTextValuesCollector;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningTextMultiValuesSource;

public class CountDistinctTextValuesCollectorManager
implements CollectorManager<CountDistinctTextValuesCollector, Long> {
    private final JoiningTextMultiValuesSource source;
    private final String field;

    public CountDistinctTextValuesCollectorManager(JoiningTextMultiValuesSource source, String field) {
        this.source = source;
        this.field = field;
    }

    public CountDistinctTextValuesCollector newCollector() throws IOException {
        return new CountDistinctTextValuesCollector(this.source, this.field);
    }

    public Long reduce(Collection<CountDistinctTextValuesCollector> collectors) throws IOException {
        if (collectors.isEmpty()) {
            return 0L;
        }
        if (collectors.size() == 1) {
            return collectors.iterator().next().globalOrds().size();
        }
        LongHashSet ords = new LongHashSet();
        for (CountDistinctTextValuesCollector collector : collectors) {
            ords.addAll((LongContainer)collector.globalOrds());
        }
        return ords.size();
    }
}

