/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValuesSource;

public class CountTextValuesCollector
extends SimpleCollector {
    private final TextMultiValuesSource source;
    private TextMultiValues values;
    private long count;
    LeafReaderContext context;

    public CountTextValuesCollector(TextMultiValuesSource source) {
        this.source = source;
    }

    public void collect(int doc) throws IOException {
        if (this.values.advanceExact(doc)) {
            while (this.values.hasNextValue()) {
                this.values.nextOrd();
                ++this.count;
            }
        }
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.values = this.source.getValues(context);
    }

    public void finish() throws IOException {
        this.values = null;
    }

    public long count() {
        return this.count;
    }
}

