/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.util.Locale;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.AggregationFunction;

public class Max
implements AggregationFunction<Max> {
    private Long max;

    @Override
    public void apply(long value) {
        if (this.max == null) {
            this.max = value;
            return;
        }
        this.max = Math.max(this.max, value);
    }

    @Override
    public void merge(AggregationFunction<Max> sibling) {
        Long other = sibling.implementation().max;
        if (other != null) {
            this.apply(other);
        }
    }

    @Override
    public Long result() {
        return this.max;
    }

    @Override
    public Max implementation() {
        return this;
    }

    public String toString() {
        return String.format(Locale.ROOT, "Max{max=%d}", this.max);
    }
}

