/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.util.Set;
import java.util.function.BiFunction;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CountDistinctTextValuesCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CountTextValuesCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningTextMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneNestableAggregation;
import org.hibernate.search.engine.search.aggregation.spi.CountValuesAggregationBuilder;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;

public class LuceneTextCountValuesAggregation
extends AbstractLuceneNestableAggregation<Long> {
    private final BiFunction<JoiningTextMultiValuesSource, String, CollectorFactory<?, Long, ?>> collectorFactorySupplier;
    private final Set<String> indexNames;
    private final String absoluteFieldPath;

    LuceneTextCountValuesAggregation(Builder builder) {
        super(builder);
        this.indexNames = builder.scope.hibernateSearchIndexNames();
        this.absoluteFieldPath = builder.field.absolutePath();
        this.collectorFactorySupplier = builder.collectorFactorySupplier;
    }

    public static Factory factory() {
        return Factory.INSTANCE;
    }

    @Override
    public LuceneSearchAggregation.Extractor<Long> request(AggregationRequestContext context) {
        NestedDocsProvider nestedDocsProvider = this.createNestedDocsProvider(context);
        JoiningTextMultiValuesSource source = JoiningTextMultiValuesSource.fromField(this.absoluteFieldPath, nestedDocsProvider);
        CollectorFactory<?, Long, ?> collectorFactory = this.collectorFactorySupplier.apply(source, this.absoluteFieldPath);
        context.requireCollector(collectorFactory);
        return new LuceneTextCountValuesAggregationExtractor(collectorFactory.getCollectorKey());
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    protected static class Builder
    extends AbstractLuceneNestableAggregation.AbstractBuilder<Long>
    implements CountValuesAggregationBuilder {
        private BiFunction<JoiningTextMultiValuesSource, String, CollectorFactory<?, Long, ?>> collectorFactorySupplier = CountTextValuesCollectorFactory::new;

        public Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field) {
            super(scope, field);
        }

        public void distinct(boolean distinct) {
            this.collectorFactorySupplier = distinct ? CountDistinctTextValuesCollectorFactory::new : CountTextValuesCollectorFactory::new;
        }

        @Override
        public AbstractLuceneNestableAggregation<Long> build() {
            return new LuceneTextCountValuesAggregation(this);
        }
    }

    protected static class Factory
    implements SearchQueryElementFactory<CountValuesAggregationBuilder.TypeSelector, LuceneSearchIndexScope<?>, LuceneSearchIndexNodeContext> {
        private static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        public CountValuesAggregationBuilder.TypeSelector create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexNodeContext node) {
            return new TypeSelector(scope, node);
        }

        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            if (!this.getClass().equals(other.getClass())) {
                throw QueryLog.INSTANCE.differentImplementationClassForQueryElement(this.getClass(), other.getClass());
            }
        }
    }

    private record LuceneTextCountValuesAggregationExtractor(CollectorKey<?, Long> collectorKey) implements LuceneSearchAggregation.Extractor<Long>
    {
        @Override
        public Long extract(AggregationExtractContext context) {
            return context.getCollectorResults(this.collectorKey);
        }
    }

    private record TypeSelector(LuceneSearchIndexScope<?> scope, LuceneSearchIndexNodeContext node) implements CountValuesAggregationBuilder.TypeSelector
    {
        public CountValuesAggregationBuilder builder() {
            return new Builder(this.scope, (LuceneSearchIndexValueFieldContext<?>)this.node.toValueField());
        }
    }
}

