/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.spi.DeferredInitializationIndexFieldAccessor;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class IndexSchemaFieldDefinitionHelper<F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexSchemaBuildContext schemaContext;
    private final DeferredInitializationIndexFieldAccessor<F> deferredInitializationAccessor = new DeferredInitializationIndexFieldAccessor();
    private boolean accessorCreated = false;

    public IndexSchemaFieldDefinitionHelper(IndexSchemaBuildContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    public IndexFieldAccessor<F> createAccessor() {
        if (this.accessorCreated) {
            throw log.cannotCreateAccessorMultipleTimes(this.schemaContext.getEventContext());
        }
        this.accessorCreated = true;
        return this.deferredInitializationAccessor;
    }

    public void initialize(IndexFieldAccessor<F> delegate) {
        this.checkAccessorCreated();
        this.deferredInitializationAccessor.initialize(delegate);
    }

    private void checkAccessorCreated() {
        if (!this.accessorCreated) {
            throw log.incompleteFieldDefinition(this.schemaContext.getEventContext());
        }
    }
}

