/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.impl.BackendBuildContextImpl;
import org.hibernate.search.engine.common.impl.MappedIndexManagerImpl;
import org.hibernate.search.engine.common.impl.RootBuildContext;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.building.impl.RootIndexModelBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexManagerBuildingState;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexModelBindingContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.SuppressingCloser;

class IndexManagerBuildingStateHolder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<String> DEFAULT_INDEX_BACKEND_NAME = ConfigurationProperty.forKey("default_backend").asString().build();
    private static final OptionalConfigurationProperty<String> INDEX_BACKEND_NAME = ConfigurationProperty.forKey("backend").asString().build();
    private static final OptionalConfigurationProperty<BeanReference<? extends BackendFactory>> BACKEND_TYPE = ConfigurationProperty.forKey("type").asBeanReference(BackendFactory.class).build();
    private final BeanProvider beanProvider;
    private final ConfigurationPropertySource propertySource;
    private final RootBuildContext rootBuildContext;
    private final Map<String, BackendBuildingState<?>> backendBuildingStateByName = new HashMap();
    private final Map<String, IndexManagerBuildingStateImpl<?>> indexManagerBuildingStateByName = new HashMap();

    IndexManagerBuildingStateHolder(BeanProvider beanProvider, ConfigurationPropertySource propertySource, RootBuildContext rootBuildContext) {
        this.beanProvider = beanProvider;
        this.propertySource = propertySource;
        this.rootBuildContext = rootBuildContext;
    }

    public IndexManagerBuildingState<?> startBuilding(String indexName, boolean multiTenancyEnabled) {
        ConfigurationPropertySource indexPropertySource = this.propertySource.withMask("indexes").withMask(indexName);
        String backendName = this.getBackendName(indexName, indexPropertySource);
        BackendBuildingState backendBuildingstate = this.backendBuildingStateByName.computeIfAbsent(backendName, this::createBackend);
        IndexManagerBuildingStateImpl<Object> state = this.indexManagerBuildingStateByName.get(indexName);
        if (state == null) {
            state = backendBuildingstate.createIndexManagerBuildingState(indexName, multiTenancyEnabled, indexPropertySource);
            this.indexManagerBuildingStateByName.put(indexName, state);
        }
        return state;
    }

    private String getBackendName(String indexName, ConfigurationPropertySource indexPropertySource) {
        Optional backendNameOptional = (Optional)INDEX_BACKEND_NAME.get(indexPropertySource);
        if (backendNameOptional.isPresent()) {
            return (String)backendNameOptional.get();
        }
        Optional defaultBackendNameOptional = (Optional)DEFAULT_INDEX_BACKEND_NAME.get(this.propertySource);
        if (defaultBackendNameOptional.isPresent()) {
            return (String)defaultBackendNameOptional.get();
        }
        throw log.indexBackendCannotBeNullOrEmpty(indexName, INDEX_BACKEND_NAME.resolveOrRaw(indexPropertySource), DEFAULT_INDEX_BACKEND_NAME.resolveOrRaw(this.propertySource));
    }

    Map<String, BackendImplementor<?>> getBackendsByName() {
        HashMap backendsByName = new HashMap();
        for (Map.Entry<String, BackendBuildingState<?>> entry : this.backendBuildingStateByName.entrySet()) {
            backendsByName.put(entry.getKey(), entry.getValue().getBuilt());
        }
        return backendsByName;
    }

    Map<String, IndexManagerImplementor<?>> getIndexManagersByName() {
        HashMap indexManagersByName = new HashMap();
        for (Map.Entry<String, IndexManagerBuildingStateImpl<?>> entry : this.indexManagerBuildingStateByName.entrySet()) {
            indexManagersByName.put(entry.getKey(), entry.getValue().getBuilt());
        }
        return indexManagersByName;
    }

    void closeOnFailure(SuppressingCloser closer) {
        closer.pushAll(state -> state.closeOnFailure(closer), this.indexManagerBuildingStateByName.values());
        closer.pushAll(BackendBuildingState::closeOnFailure, this.backendBuildingStateByName.values());
    }

    private BackendBuildingState<?> createBackend(String backendName) {
        ConfigurationPropertySource backendPropertySource = this.propertySource.withMask("backends").withMask(backendName);
        try (BeanHolder backendFactoryHolder = BACKEND_TYPE.getAndMapOrThrow(backendPropertySource, this.beanProvider::getBean, key -> log.backendTypeCannotBeNullOrEmpty(backendName, (String)key));){
            BackendBuildContextImpl backendBuildContext = new BackendBuildContextImpl(this.rootBuildContext);
            BackendImplementor<?> backend = ((BackendFactory)backendFactoryHolder.get()).create(backendName, backendBuildContext, backendPropertySource);
            BackendBuildingState backendBuildingState = new BackendBuildingState(backendBuildContext, backendPropertySource, backend);
            return backendBuildingState;
        }
    }

    private class IndexManagerBuildingStateImpl<D extends DocumentElement>
    implements IndexManagerBuildingState<D> {
        private final String indexName;
        private final IndexManagerBuilder<D> builder;
        private final IndexModelBindingContext bindingContext;
        private IndexManagerImplementor<D> built;

        IndexManagerBuildingStateImpl(String indexName, IndexManagerBuilder<D> builder, IndexModelBindingContext bindingContext) {
            this.indexName = indexName;
            this.builder = builder;
            this.bindingContext = bindingContext;
        }

        void closeOnFailure(SuppressingCloser closer) {
            if (this.built != null) {
                closer.push(IndexManagerImplementor::close, this.built);
            } else {
                closer.push(IndexManagerBuilder::closeOnFailure, this.builder);
            }
        }

        @Override
        public String getIndexName() {
            return this.indexName;
        }

        @Override
        public IndexModelBindingContext getRootBindingContext() {
            return this.bindingContext;
        }

        @Override
        public MappedIndexManager<D> build() {
            if (this.built != null) {
                throw new AssertionFailure("Trying to build index manager " + this.indexName + " twice. There is probably a bug in the mapper implementation.");
            }
            this.built = this.builder.build();
            return new MappedIndexManagerImpl<D>(this.built);
        }

        public IndexManagerImplementor<D> getBuilt() {
            if (this.built == null) {
                throw new AssertionFailure("Index manager " + this.indexName + " was not built by the mapper as expected. There is probably a bug in the mapper implementation.");
            }
            return this.built;
        }
    }

    private class BackendBuildingState<D extends DocumentElement> {
        private final BackendBuildContext backendBuildContext;
        private final ConfigurationPropertySource defaultIndexPropertySource;
        private final BackendImplementor<D> backend;

        private BackendBuildingState(BackendBuildContext backendBuildContext, ConfigurationPropertySource backendPropertySource, BackendImplementor<D> backend) {
            this.backendBuildContext = backendBuildContext;
            this.defaultIndexPropertySource = backendPropertySource.withMask("index_defaults");
            this.backend = backend;
        }

        IndexManagerBuildingStateImpl<D> createIndexManagerBuildingState(String indexName, boolean multiTenancyEnabled, ConfigurationPropertySource indexPropertySource) {
            ConfigurationPropertySource defaultedIndexPropertySource = indexPropertySource.withFallback(this.defaultIndexPropertySource);
            IndexManagerBuilder<D> builder = this.backend.createIndexManagerBuilder(indexName, multiTenancyEnabled, this.backendBuildContext, defaultedIndexPropertySource);
            IndexSchemaRootNodeBuilder schemaRootNodeBuilder = builder.getSchemaRootNodeBuilder();
            RootIndexModelBindingContext bindingContext = new RootIndexModelBindingContext(schemaRootNodeBuilder);
            return new IndexManagerBuildingStateImpl<D>(indexName, builder, bindingContext);
        }

        void closeOnFailure() {
            this.backend.close();
        }

        BackendImplementor<D> getBuilt() {
            return this.backend;
        }
    }
}

