/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.spi;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.common.impl.ErrorContextImpl;
import org.hibernate.search.engine.common.spi.ErrorContext;

public class ErrorContextBuilder {
    private Throwable th;
    private Object operationAtFault;
    private Iterable<Object> workToBeDone;
    private List<Object> failingOperations;
    private List<Object> operationsThatWorked;
    private IndexManager indexManager;

    public ErrorContextBuilder errorThatOccurred(Throwable th) {
        this.th = th;
        return this;
    }

    public ErrorContextBuilder operationAtFault(Object operationAtFault) {
        this.operationAtFault = operationAtFault;
        return this;
    }

    public ErrorContextBuilder addWorkThatFailed(Object failedWork) {
        this.getFailingOperations().add(failedWork);
        return this;
    }

    public ErrorContextBuilder addAllWorkThatFailed(List<Object> worksThatFailed) {
        this.getFailingOperations().addAll(worksThatFailed);
        return this;
    }

    public ErrorContextBuilder workCompleted(Object luceneWork) {
        this.getOperationsThatWorked().add(luceneWork);
        return this;
    }

    public ErrorContextBuilder indexManager(IndexManager indexName) {
        this.indexManager = indexName;
        return this;
    }

    public ErrorContextBuilder allWorkToBeDone(Iterable<Object> workOnWriter) {
        this.workToBeDone = workOnWriter;
        return this;
    }

    public ErrorContext createErrorContext() {
        ErrorContextImpl context = new ErrorContextImpl();
        context.setThrowable(this.th);
        if (this.operationAtFault != null) {
            context.setOperationAtFault(this.operationAtFault);
        } else if (this.workToBeDone != null) {
            ArrayList<Object> workLeft = new ArrayList<Object>();
            for (Object work : this.workToBeDone) {
                workLeft.add(work);
            }
            if (this.operationsThatWorked != null) {
                workLeft.removeAll(this.operationsThatWorked);
            }
            if (!workLeft.isEmpty()) {
                context.setOperationAtFault(workLeft.remove(0));
                this.getFailingOperations().addAll(workLeft);
            }
        }
        context.setFailingOperations(this.getFailingOperations());
        context.setIndexManager(this.indexManager);
        return context;
    }

    private List<Object> getFailingOperations() {
        if (this.failingOperations == null) {
            this.failingOperations = new ArrayList<Object>();
        }
        return this.failingOperations;
    }

    private List<Object> getOperationsThatWorked() {
        if (this.operationsThatWorked == null) {
            this.operationsThatWorked = new LinkedList<Object>();
        }
        return this.operationsThatWorked;
    }
}

