/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.spi;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.engine.common.spi.ErrorContext;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.logging.Log;

public class LogErrorHandler
implements ErrorHandler {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    @Override
    public void handle(ErrorContext context) {
        List<Object> failingOperations = context.getFailingOperations();
        Object primaryFailure = context.getOperationAtFault();
        Throwable exceptionThatOccurred = context.getThrowable();
        StringBuilder errorMsg = new StringBuilder();
        if (exceptionThatOccurred != null) {
            errorMsg.append("Exception occurred ").append(exceptionThatOccurred).append("\n");
        }
        if (primaryFailure != null) {
            errorMsg.append("Primary Failure:\n");
            LogErrorHandler.appendFailureMessage(errorMsg, primaryFailure);
        }
        if (!failingOperations.isEmpty()) {
            errorMsg.append("Subsequent failures:\n");
            for (Object workThatFailed : failingOperations) {
                LogErrorHandler.appendFailureMessage(errorMsg, workThatFailed);
            }
        }
        this.handleException(errorMsg.toString(), exceptionThatOccurred);
    }

    public static final void appendFailureMessage(StringBuilder message, Object workThatFailed) {
        message.append(workThatFailed.toString());
    }

    @Override
    public void handleException(String errorMsg, Throwable exception) {
        log.exceptionOccurred(errorMsg, exception);
    }
}

