/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.util.impl.common.SuppressingCloser;

final class CastingBeanReference<T>
implements BeanReference<T> {
    private final BeanReference<?> casted;
    private final Class<T> expectedType;

    CastingBeanReference(BeanReference<?> casted, Class<T> expectedType) {
        this.casted = casted;
        this.expectedType = expectedType;
    }

    @Override
    public BeanHolder<T> getBean(BeanProvider beanProvider) {
        BeanHolder<?> beanHolder = this.casted.getBean(beanProvider);
        try {
            this.expectedType.cast(beanHolder.get());
            return beanHolder;
        }
        catch (Exception e) {
            new SuppressingCloser((Throwable)e).push(beanHolder);
            throw e;
        }
    }

    @Override
    public <U> BeanReference<? extends U> asSubTypeOf(Class<U> expectedType2) {
        if (expectedType2.isAssignableFrom(this.expectedType)) {
            return this;
        }
        return this.casted.asSubTypeOf(expectedType2);
    }
}

