/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.util.impl.common.Contracts;

final class InstanceBeanReference<T>
implements BeanReference<T> {
    private final T instance;

    InstanceBeanReference(T instance) {
        Contracts.assertNotNull(instance, (String)"instance");
        this.instance = instance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[instance=" + this.instance + "]";
    }

    @Override
    public BeanHolder<T> getBean(BeanProvider beanProvider) {
        return BeanHolder.of(this.instance);
    }

    @Override
    public <U> BeanReference<? extends U> asSubTypeOf(Class<U> expectedType) {
        expectedType.cast(this.instance);
        return this;
    }
}

