/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.spi;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.spi.BeanResolver;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoaderHelper;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;

public final class ReflectionBeanResolver
implements BeanResolver {
    private final ClassResolver classResolver;

    public ReflectionBeanResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public void close() {
    }

    @Override
    public <T> BeanHolder<T> resolve(Class<T> typeReference) {
        return BeanHolder.of(this.resolveNoClosingNecessary(typeReference));
    }

    public <T> T resolveNoClosingNecessary(Class<T> typeReference) {
        return ClassLoaderHelper.untypedInstanceFromClass(typeReference, typeReference.getName());
    }

    @Override
    public <T> BeanHolder<T> resolve(Class<T> typeReference, String implementationFullyQualifiedClassName) {
        return BeanHolder.of(this.resolveNoClosingNecessary(typeReference, implementationFullyQualifiedClassName));
    }

    public <T> T resolveNoClosingNecessary(Class<T> typeReference, String implementationFullyQualifiedClassName) {
        Class<T> implementationClass = ClassLoaderHelper.classForName(typeReference, implementationFullyQualifiedClassName, typeReference.getName(), this.classResolver);
        return ClassLoaderHelper.untypedInstanceFromClass(implementationClass, implementationFullyQualifiedClassName);
    }
}

