/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.dsl.predicate.NestedPredicateContext;
import org.hibernate.search.engine.search.dsl.predicate.NestedPredicateFieldContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.spi.AbstractSearchPredicateTerminalContext;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.impl.common.LoggerFactory;

class NestedPredicateContextImpl<B>
extends AbstractSearchPredicateTerminalContext<B>
implements NestedPredicateContext,
NestedPredicateFieldContext,
SearchPredicateTerminalContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SearchPredicateFactoryContext factoryContext;
    private NestedPredicateBuilder<B> builder;
    private B childPredicateBuilder;

    NestedPredicateContextImpl(SearchPredicateBuilderFactory<?, B> factory, SearchPredicateFactoryContext factoryContext) {
        super(factory);
        this.factoryContext = factoryContext;
    }

    @Override
    public NestedPredicateFieldContext onObjectField(String absoluteFieldPath) {
        this.builder = this.factory.nested(absoluteFieldPath);
        return this;
    }

    @Override
    public SearchPredicateTerminalContext nest(SearchPredicate searchPredicate) {
        if (this.childPredicateBuilder != null) {
            throw log.cannotAddMultiplePredicatesToNestedPredicate();
        }
        this.childPredicateBuilder = this.factory.toImplementation(searchPredicate);
        return this;
    }

    @Override
    public SearchPredicateTerminalContext nest(Function<? super SearchPredicateFactoryContext, SearchPredicate> predicateContributor) {
        return this.nest(predicateContributor.apply(this.factoryContext));
    }

    @Override
    protected B toImplementation() {
        this.builder.nested(this.childPredicateBuilder);
        return this.builder.toImplementation();
    }
}

