/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateFromContext;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.impl.common.LoggerFactory;

class RangePredicateFieldSetContextImpl<B>
implements RangePredicateFieldSetContext,
AbstractMultiFieldPredicateCommonState.FieldSetContext<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final RangePredicateFromContextImpl<B> fromContext;
    private final List<String> absoluteFieldPaths;
    private final List<RangePredicateBuilder<B>> predicateBuilders = new ArrayList<RangePredicateBuilder<B>>();

    RangePredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.range(absoluteFieldPath));
        }
        this.fromContext = new RangePredicateFromContextImpl<B>(commonState);
    }

    @Override
    public RangePredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new RangePredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public RangePredicateFieldSetContext boostedTo(float boost) {
        this.predicateBuilders.forEach(b -> b.boost(boost));
        return this;
    }

    @Override
    public RangePredicateFromContext from(Object value) {
        return this.fromContext.from(value);
    }

    @Override
    public RangePredicateTerminalContext above(Object value) {
        return this.commonState.above(value);
    }

    @Override
    public RangePredicateTerminalContext below(Object value) {
        return this.commonState.below(value);
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (RangePredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class RangePredicateFromContextImpl<B>
    implements RangePredicateFromContext {
        private final CommonState<B> delegate;

        RangePredicateFromContextImpl(CommonState<B> delegate) {
            this.delegate = delegate;
        }

        @Override
        public RangePredicateTerminalContext to(Object value) {
            return this.delegate.below(value);
        }

        @Override
        public RangePredicateFromContext excludeLimit() {
            ((CommonState)this.delegate).getQueryBuilders().forEach(RangePredicateBuilder::excludeLowerLimit);
            return this;
        }

        RangePredicateFromContext from(Object value) {
            if (value != null) {
                ((CommonState)this.delegate).hasNonNullBound = true;
                ((CommonState)this.delegate).getQueryBuilders().forEach(q -> q.lowerLimit(value));
            }
            return this;
        }
    }

    static class CommonState<B>
    extends AbstractMultiFieldPredicateCommonState<B, RangePredicateFieldSetContextImpl<B>>
    implements RangePredicateTerminalContext {
        private boolean hasNonNullBound = false;
        protected boolean excludeUpperLimit = false;

        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
        }

        @Override
        public SearchPredicateTerminalContext excludeLimit() {
            this.getQueryBuilders().forEach(this.excludeUpperLimit ? RangePredicateBuilder::excludeUpperLimit : RangePredicateBuilder::excludeLowerLimit);
            return this;
        }

        @Override
        protected B toImplementation() {
            this.checkHasNonNullBound();
            return super.toImplementation();
        }

        RangePredicateTerminalContext above(Object value) {
            this.excludeUpperLimit = false;
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.lowerLimit(value));
            }
            this.checkHasNonNullBound();
            return this;
        }

        RangePredicateTerminalContext below(Object value) {
            this.excludeUpperLimit = true;
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.upperLimit(value));
            }
            this.checkHasNonNullBound();
            return this;
        }

        private List<String> collectAbsoluteFieldPaths() {
            return this.getFieldSetContexts().stream().flatMap(f -> ((RangePredicateFieldSetContextImpl)f).absoluteFieldPaths.stream()).collect(Collectors.toList());
        }

        private void checkHasNonNullBound() {
            if (!this.hasNonNullBound) {
                throw log.rangePredicateCannotMatchNullValue(this.collectAbsoluteFieldPaths());
            }
        }

        private Stream<RangePredicateBuilder<B>> getQueryBuilders() {
            return this.getFieldSetContexts().stream().flatMap(f -> ((RangePredicateFieldSetContextImpl)f).predicateBuilders.stream());
        }
    }
}

