/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spatial;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;
import org.hibernate.search.util.impl.common.CollectionHelper;
import org.hibernate.search.util.impl.common.Contracts;
import org.hibernate.search.util.impl.common.LoggerFactory;

final class ImmutableGeoPolygon
implements GeoPolygon {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private List<GeoPoint> points;

    ImmutableGeoPolygon(List<GeoPoint> points) {
        Contracts.assertNotNull(points, (String)"points");
        GeoPoint firstPoint = points.get(0);
        GeoPoint lastPoint = points.get(points.size() - 1);
        if (!firstPoint.equals(lastPoint)) {
            throw log.invalidGeoPolygonFirstPointNotIdenticalToLastPoint(firstPoint, lastPoint);
        }
        this.points = CollectionHelper.toImmutableList(new ArrayList<GeoPoint>(points));
    }

    ImmutableGeoPolygon(GeoPoint firstPoint, GeoPoint secondPoint, GeoPoint thirdPoint, GeoPoint fourthPoint, GeoPoint ... additionalPoints) {
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>();
        points.add(firstPoint);
        points.add(secondPoint);
        points.add(thirdPoint);
        points.add(fourthPoint);
        Collections.addAll(points, additionalPoints);
        GeoPoint lastPoint = (GeoPoint)points.get(points.size() - 1);
        if (!firstPoint.equals(lastPoint)) {
            throw log.invalidGeoPolygonFirstPointNotIdenticalToLastPoint(firstPoint, lastPoint);
        }
        this.points = CollectionHelper.toImmutableList(points);
    }

    @Override
    public List<GeoPoint> getPoints() {
        return this.points;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGeoPolygon that = (ImmutableGeoPolygon)obj;
        return that.points.equals(this.points);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public String toString() {
        return "ImmutableGeoPolygon[points=" + this.points + "]";
    }
}

