/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.engine.search.dsl.projection.impl;

import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.projection.FieldProjectionContext;
import org.hibernate.search.engine.search.projection.spi.ProjectionConverter;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;


public class FieldProjectionContextImpl<T> implements FieldProjectionContext<T> {

	private final FieldProjectionBuilder<T> fieldProjectionBuilder;

	FieldProjectionContextImpl(SearchProjectionBuilderFactory factory, String absoluteFieldPath, Class<T> clazz, ProjectionConverter dslConverter) {
		this.fieldProjectionBuilder = factory.field( absoluteFieldPath, clazz, dslConverter );
	}

	@Override
	public SearchProjection<T> toProjection() {
		return fieldProjectionBuilder.build();
	}

}
