/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.util.List;
import org.hibernate.search.engine.environment.bean.CompositeBeanHolder;
import org.hibernate.search.engine.environment.bean.SimpleBeanHolder;

public interface BeanHolder<T>
extends AutoCloseable {
    public T get();

    @Override
    public void close();

    public static <T> BeanHolder<T> of(T instance) {
        return new SimpleBeanHolder<T>(instance);
    }

    public static <T> BeanHolder<List<T>> of(List<? extends BeanHolder<? extends T>> beanHolders) {
        return new CompositeBeanHolder(beanHolders);
    }
}

