/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.impl;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.EngineSpiSettings;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.impl.BeanConfigurationContextImpl;
import org.hibernate.search.engine.environment.bean.impl.BeanCreationContextImpl;
import org.hibernate.search.engine.environment.bean.impl.BeanResolverOnlyBeanProvider;
import org.hibernate.search.engine.environment.bean.impl.ConfiguredBeanKey;
import org.hibernate.search.engine.environment.bean.spi.BeanConfigurer;
import org.hibernate.search.engine.environment.bean.spi.BeanCreationContext;
import org.hibernate.search.engine.environment.bean.spi.BeanFactory;
import org.hibernate.search.engine.environment.bean.spi.BeanResolver;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Contracts;

public final class ConfiguredBeanProvider
implements BeanProvider {
    private static final ConfigurationProperty<List<BeanReference<? extends BeanConfigurer>>> BEAN_CONFIGURERS = ConfigurationProperty.forKey("bean_configurers").asBeanReference(BeanConfigurer.class).multivalued(Pattern.compile("\\s+")).withDefault(EngineSpiSettings.Defaults.BEAN_CONFIGURERS).build();
    private final BeanResolver beanResolver;
    private final Map<ConfiguredBeanKey<?>, BeanFactory<?>> explicitlyConfiguredBeans;
    private final BeanCreationContext beanCreationContext;

    public ConfiguredBeanProvider(ClassResolver classResolver, BeanResolver beanResolver, ConfigurationPropertySource configurationPropertySource) {
        this.beanResolver = beanResolver;
        BeanConfigurationContextImpl configurationContext = new BeanConfigurationContextImpl();
        for (BeanConfigurer beanConfigurer : classResolver.loadJavaServices(BeanConfigurer.class)) {
            beanConfigurer.configure(configurationContext);
        }
        BeanResolverOnlyBeanProvider beanProviderForConfigurers = new BeanResolverOnlyBeanProvider(beanResolver);
        try (BeanHolder beanConfigurersFromConfigurationProperties = BEAN_CONFIGURERS.getAndTransform(configurationPropertySource, beanProviderForConfigurers::getBeans);){
            for (BeanConfigurer beanConfigurer : (List)beanConfigurersFromConfigurationProperties.get()) {
                beanConfigurer.configure(configurationContext);
            }
        }
        this.explicitlyConfiguredBeans = configurationContext.getConfiguredBeans();
        this.beanCreationContext = new BeanCreationContextImpl(this);
    }

    @Override
    public <T> BeanHolder<T> getBean(Class<T> typeReference) {
        Contracts.assertNotNull(typeReference, (String)"typeReference");
        try {
            return this.beanResolver.resolve(typeReference);
        }
        catch (SearchException e) {
            return this.fallbackToConfiguredBeans(e, typeReference, null);
        }
    }

    @Override
    public <T> BeanHolder<T> getBean(Class<T> typeReference, String nameReference) {
        Contracts.assertNotNull(typeReference, (String)"typeReference");
        Contracts.assertNotNullNorEmpty((String)nameReference, (String)"nameReference");
        try {
            return this.beanResolver.resolve(typeReference, nameReference);
        }
        catch (SearchException e) {
            return this.fallbackToConfiguredBeans(e, typeReference, nameReference);
        }
    }

    private <T> BeanHolder<T> fallbackToConfiguredBeans(SearchException e, Class<T> typeReference, String nameReference) {
        try {
            BeanHolder<T> explicitlyConfiguredBean = this.getExplicitlyConfiguredBean(typeReference, nameReference);
            if (explicitlyConfiguredBean != null) {
                return explicitlyConfiguredBean;
            }
        }
        catch (RuntimeException e2) {
            e.addSuppressed((Throwable)e2);
        }
        throw e;
    }

    private <T> BeanHolder<T> getExplicitlyConfiguredBean(Class<T> exposedType, String name) {
        ConfiguredBeanKey<T> key = new ConfiguredBeanKey<T>(exposedType, name);
        BeanFactory<?> factory = this.explicitlyConfiguredBeans.get(key);
        if (factory == null) {
            return null;
        }
        return factory.create(this.beanCreationContext);
    }
}

