/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.SimpleQueryStringPredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.SimpleQueryStringPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.spi.AbstractSearchPredicateTerminalContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class SimpleQueryStringPredicateFieldSetContextImpl<B>
implements SimpleQueryStringPredicateFieldSetContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<SimpleQueryStringPredicateBuilder.FieldContext> fieldContexts = new ArrayList<SimpleQueryStringPredicateBuilder.FieldContext>();

    SimpleQueryStringPredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.fieldContexts.add(commonState.field(absoluteFieldPath));
        }
    }

    @Override
    public SimpleQueryStringPredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new SimpleQueryStringPredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public SimpleQueryStringPredicateFieldSetContext boostedTo(float boost) {
        this.fieldContexts.forEach(c -> c.boost(boost));
        return this;
    }

    @Override
    public SimpleQueryStringPredicateTerminalContext matching(String simpleQueryString) {
        return ((CommonState)this.commonState).matching(simpleQueryString);
    }

    static class CommonState<B>
    extends AbstractSearchPredicateTerminalContext<B>
    implements SimpleQueryStringPredicateTerminalContext {
        private final SimpleQueryStringPredicateBuilder<B> builder;
        private final List<SimpleQueryStringPredicateFieldSetContextImpl<B>> fieldSetContexts = new ArrayList<SimpleQueryStringPredicateFieldSetContextImpl<B>>();

        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
            this.builder = factory.simpleQueryString();
        }

        @Override
        protected B toImplementation() {
            return this.builder.toImplementation();
        }

        void add(SimpleQueryStringPredicateFieldSetContextImpl<B> fieldSetContext) {
            this.fieldSetContexts.add(fieldSetContext);
        }

        SimpleQueryStringPredicateBuilder.FieldContext field(String absoluteFieldPath) {
            return this.builder.field(absoluteFieldPath);
        }

        private SimpleQueryStringPredicateTerminalContext matching(String simpleQueryString) {
            if (simpleQueryString == null) {
                throw log.simpleQueryStringCannotBeNull(this.collectAbsoluteFieldPaths());
            }
            this.builder.simpleQueryString(simpleQueryString);
            return this;
        }

        @Override
        public CommonState<B> withConstantScore() {
            this.builder.withConstantScore();
            return this;
        }

        @Override
        public CommonState<B> boostedTo(float boost) {
            this.builder.boost(boost);
            return this;
        }

        @Override
        public SimpleQueryStringPredicateTerminalContext withAndAsDefaultOperator() {
            this.builder.withAndAsDefaultOperator();
            return this;
        }

        @Override
        public SimpleQueryStringPredicateTerminalContext analyzer(String analyzerName) {
            this.builder.analyzer(analyzerName);
            return this;
        }

        @Override
        public SimpleQueryStringPredicateTerminalContext skipAnalysis() {
            this.builder.skipAnalysis();
            return this;
        }

        private List<String> collectAbsoluteFieldPaths() {
            return this.fieldSetContexts.stream().flatMap(f -> ((SimpleQueryStringPredicateFieldSetContextImpl)f).absoluteFieldPaths.stream()).collect(Collectors.toList());
        }
    }
}

