/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.orchestration.spi;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractWorkOrchestrator<W>
implements AutoCloseable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private boolean open = true;
    private final ReadWriteLock shutdownLock = new ReentrantReadWriteLock();

    protected AbstractWorkOrchestrator(String name) {
        this.name = name;
    }

    protected final String getName() {
        return this.name;
    }

    @Override
    public final void close() {
        this.shutdownLock.writeLock().lock();
        try {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.doClose();
        }
        finally {
            this.shutdownLock.writeLock().unlock();
        }
    }

    protected abstract void doSubmit(W var1) throws InterruptedException;

    protected abstract void doClose();

    protected final void submit(W workSet) {
        if (!this.shutdownLock.readLock().tryLock()) {
            throw log.orchestratorShutDownBeforeSubmittingWorkset(this.name);
        }
        try {
            if (!this.open) {
                throw log.orchestratorShutDownBeforeSubmittingWorkset(this.name);
            }
            this.doSubmit(workSet);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.threadInterruptedWhileSubmittingWorkset(this.name);
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }
}

