/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaElementImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryContext;
import org.hibernate.search.engine.mapper.mapping.building.impl.ConfiguredIndexSchemaNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.impl.IndexedEmbeddedBindingContextImpl;
import org.hibernate.search.engine.mapper.mapping.building.impl.NotifyingNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedBindingContext;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;

abstract class AbstractIndexBindingContext<B extends IndexSchemaObjectNodeBuilder>
implements IndexBindingContext {
    private final IndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder;
    final B indexSchemaObjectNodeBuilder;
    final ConfiguredIndexSchemaNestingContext nestingContext;

    AbstractIndexBindingContext(IndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder, B indexSchemaObjectNodeBuilder, ConfiguredIndexSchemaNestingContext nestingContext) {
        this.indexSchemaRootNodeBuilder = indexSchemaRootNodeBuilder;
        this.indexSchemaObjectNodeBuilder = indexSchemaObjectNodeBuilder;
        this.nestingContext = nestingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexSchemaObjectNodeBuilder=" + this.indexSchemaObjectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public IndexFieldTypeFactoryContext createTypeFactory(IndexFieldTypeDefaultsProvider defaultsProvider) {
        return this.indexSchemaRootNodeBuilder.createTypeFactory(defaultsProvider);
    }

    @Override
    public IndexSchemaElement getSchemaElement() {
        return new IndexSchemaElementImpl<B>(this.createTypeFactory(), this.indexSchemaObjectNodeBuilder, this.nestingContext, this.isParentMultivaluedAndWithoutObjectField());
    }

    @Override
    public IndexSchemaElement getSchemaElement(IndexSchemaContributionListener listener) {
        return new IndexSchemaElementImpl<B>(this.createTypeFactory(), this.indexSchemaObjectNodeBuilder, new NotifyingNestingContext(this.nestingContext, listener), this.isParentMultivaluedAndWithoutObjectField());
    }

    @Override
    public Optional<IndexedEmbeddedBindingContext> addIndexedEmbeddedIfIncluded(MappableTypeModel parentTypeModel, boolean multiValued, String relativePrefix, ObjectFieldStorage storage, Integer maxDepth, Set<String> includePaths) {
        return this.nestingContext.addIndexedEmbeddedIfIncluded(parentTypeModel, relativePrefix, maxDepth, includePaths, new NestedContextBuilderImpl(this.indexSchemaRootNodeBuilder, (IndexSchemaObjectNodeBuilder)this.indexSchemaObjectNodeBuilder, storage, this.isParentMultivaluedAndWithoutObjectField() || multiValued));
    }

    abstract boolean isParentMultivaluedAndWithoutObjectField();

    private static class NestedContextBuilderImpl
    implements ConfiguredIndexSchemaNestingContext.NestedContextBuilder<IndexedEmbeddedBindingContext> {
        private final IndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder;
        private IndexSchemaObjectNodeBuilder currentNodeBuilder;
        private final ObjectFieldStorage storage;
        private final List<IndexObjectFieldReference> parentIndexObjectReferences = new ArrayList<IndexObjectFieldReference>();
        private boolean multiValued;

        private NestedContextBuilderImpl(IndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder, IndexSchemaObjectNodeBuilder currentNodeBuilder, ObjectFieldStorage storage, boolean multiValued) {
            this.indexSchemaRootNodeBuilder = indexSchemaRootNodeBuilder;
            this.currentNodeBuilder = currentNodeBuilder;
            this.storage = storage;
            this.multiValued = multiValued;
        }

        @Override
        public void appendObject(String objectName) {
            IndexSchemaObjectFieldNodeBuilder nextNodeBuilder = this.currentNodeBuilder.addObjectField(objectName, this.storage);
            if (this.multiValued) {
                this.multiValued = false;
                nextNodeBuilder.multiValued();
            }
            this.parentIndexObjectReferences.add(nextNodeBuilder.toReference());
            this.currentNodeBuilder = nextNodeBuilder;
        }

        @Override
        public IndexedEmbeddedBindingContext build(ConfiguredIndexSchemaNestingContext nestingContext) {
            return new IndexedEmbeddedBindingContextImpl(this.indexSchemaRootNodeBuilder, this.currentNodeBuilder, this.parentIndexObjectReferences, nestingContext, this.multiValued);
        }
    }
}

