/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.projection.impl;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.projection.CompositeProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.DistanceToFieldProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.DocumentReferenceProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.EntityProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.EntityReferenceProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.FieldProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.ScoreProjectionContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContextExtension;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryExtensionContext;
import org.hibernate.search.engine.search.dsl.projection.impl.CompositeProjectionContextImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.DistanceToFieldProjectionContextImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.DocumentReferenceProjectionContextImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.EntityProjectionContextImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.EntityReferenceProjectionContextImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.FieldProjectionContextImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.ScoreProjectionContextImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.SearchProjectionFactoryExtensionContextImpl;
import org.hibernate.search.engine.search.projection.ProjectionConverter;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.function.TriFunction;
import org.hibernate.search.util.common.impl.Contracts;

public class DefaultSearchProjectionFactoryContext<R, E>
implements SearchProjectionFactoryContext<R, E> {
    private final SearchProjectionBuilderFactory factory;

    public DefaultSearchProjectionFactoryContext(SearchProjectionBuilderFactory factory) {
        this.factory = factory;
    }

    @Override
    public DocumentReferenceProjectionContext documentReference() {
        return new DocumentReferenceProjectionContextImpl(this.factory);
    }

    @Override
    public <T> FieldProjectionContext<T> field(String absoluteFieldPath, Class<T> clazz, ProjectionConverter projectionConverter) {
        Contracts.assertNotNull(clazz, (String)"clazz");
        return new FieldProjectionContextImpl<T>(this.factory, absoluteFieldPath, clazz, projectionConverter);
    }

    @Override
    public FieldProjectionContext<Object> field(String absoluteFieldPath, ProjectionConverter projectionConverter) {
        return this.field(absoluteFieldPath, Object.class, projectionConverter);
    }

    @Override
    public EntityReferenceProjectionContext<R> entityReference() {
        return new EntityReferenceProjectionContextImpl(this.factory);
    }

    @Override
    public EntityProjectionContext<E> entity() {
        return new EntityProjectionContextImpl(this.factory);
    }

    @Override
    public ScoreProjectionContext score() {
        return new ScoreProjectionContextImpl(this.factory);
    }

    @Override
    public DistanceToFieldProjectionContext distance(String absoluteFieldPath, GeoPoint center) {
        Contracts.assertNotNull((Object)center, (String)"center");
        return new DistanceToFieldProjectionContextImpl(this.factory, absoluteFieldPath, center);
    }

    @Override
    public <T> CompositeProjectionContext<T> composite(Function<List<?>, T> transformer, SearchProjection<?> ... projections) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNullNorEmpty((Object[])projections, (String)"projections");
        return new CompositeProjectionContextImpl<T>(this.factory, transformer, projections);
    }

    @Override
    public <P, T> CompositeProjectionContext<T> composite(Function<P, T> transformer, SearchProjection<P> projection) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection, (String)"projection");
        return new CompositeProjectionContextImpl<T>(this.factory, transformer, projection);
    }

    @Override
    public <P1, P2, T> CompositeProjectionContext<T> composite(BiFunction<P1, P2, T> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection1, (String)"projection1");
        Contracts.assertNotNull(projection2, (String)"projection2");
        return new CompositeProjectionContextImpl<T>(this.factory, transformer, projection1, projection2);
    }

    @Override
    public <P1, P2, P3, T> CompositeProjectionContext<T> composite(TriFunction<P1, P2, P3, T> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection1, (String)"projection1");
        Contracts.assertNotNull(projection2, (String)"projection2");
        Contracts.assertNotNull(projection3, (String)"projection3");
        return new CompositeProjectionContextImpl<T>(this.factory, transformer, projection1, projection2, projection3);
    }

    @Override
    public <T> T extension(SearchProjectionFactoryContextExtension<T, R, E> extension) {
        return DslExtensionState.returnIfSupported(extension, extension.extendOptional(this, this.factory));
    }

    @Override
    public <T> SearchProjectionFactoryExtensionContext<T, R, E> extension() {
        return new SearchProjectionFactoryExtensionContextImpl(this, this.factory);
    }
}

