/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.query.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionTerminalContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultContext;
import org.hibernate.search.engine.search.dsl.query.impl.DefaultSearchQueryContext;
import org.hibernate.search.engine.search.dsl.query.spi.AbstractSearchQueryResultDefinitionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public final class DefaultSearchQueryResultDefinitionContext<R, E, C>
extends AbstractSearchQueryResultDefinitionContext<SearchQueryContext<?, E, ?>, R, E, SearchProjectionFactoryContext<R, E>, SearchPredicateFactoryContext, C> {
    private final IndexScope<C> indexScope;
    private final SessionContextImplementor sessionContext;
    private final LoadingContextBuilder<R, E> loadingContextBuilder;

    public DefaultSearchQueryResultDefinitionContext(IndexScope<C> indexScope, SessionContextImplementor sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public SearchQueryResultContext<?, E, ?> asEntity() {
        SearchQueryBuilder<E, C> builder = this.indexScope.getSearchQueryBuilderFactory().asEntity(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryContext<E, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryResultContext<?, R, ?> asEntityReference() {
        SearchQueryBuilder<R, C> builder = this.indexScope.getSearchQueryBuilderFactory().asReference(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryContext<R, C>(this.indexScope, builder);
    }

    @Override
    public <P> SearchQueryResultContext<?, P, ?> asProjection(Function<? super SearchProjectionFactoryContext<R, E>, ? extends SearchProjectionTerminalContext<P>> projectionContributor) {
        SearchProjectionFactoryContext factoryContext = this.createDefaultProjectionFactoryContext();
        SearchProjection<P> projection = projectionContributor.apply(factoryContext).toProjection();
        return this.asProjection(projection);
    }

    @Override
    public <P> SearchQueryResultContext<?, P, ?> asProjection(SearchProjection<P> projection) {
        SearchQueryBuilder<P, C> builder = this.indexScope.getSearchQueryBuilderFactory().asProjection(this.sessionContext, this.loadingContextBuilder, projection);
        return new DefaultSearchQueryContext<P, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryResultContext<?, List<?>, ?> asProjections(SearchProjection<?> ... projections) {
        SearchQueryBuilder<List<R>, C> builder = this.indexScope.getSearchQueryBuilderFactory().asProjections(this.sessionContext, this.loadingContextBuilder, projections);
        return new DefaultSearchQueryContext<List<R>, C>(this.indexScope, builder);
    }

    @Override
    public SearchQueryContext<?, E, ?> predicate(Function<? super SearchPredicateFactoryContext, ? extends SearchPredicateTerminalContext> predicateContributor) {
        return this.asEntity().predicate(predicateContributor);
    }

    @Override
    public SearchQueryContext<?, E, ?> predicate(SearchPredicate predicate) {
        return this.asEntity().predicate(predicate);
    }

    @Override
    protected IndexScope<C> getIndexScope() {
        return this.indexScope;
    }

    @Override
    protected SessionContextImplementor getSessionContext() {
        return this.sessionContext;
    }

    @Override
    protected LoadingContextBuilder<R, E> getLoadingContextBuilder() {
        return this.loadingContextBuilder;
    }
}

