/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.sort.impl;

import java.util.function.Consumer;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.dsl.sort.CompositeSortContext;
import org.hibernate.search.engine.search.dsl.sort.DistanceSortContext;
import org.hibernate.search.engine.search.dsl.sort.FieldSortContext;
import org.hibernate.search.engine.search.dsl.sort.NonEmptySortContext;
import org.hibernate.search.engine.search.dsl.sort.ScoreSortContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryContextExtension;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryExtensionContext;
import org.hibernate.search.engine.search.dsl.sort.impl.CompositeSortContextImpl;
import org.hibernate.search.engine.search.dsl.sort.impl.DistanceSortContextImpl;
import org.hibernate.search.engine.search.dsl.sort.impl.FieldSortContextImpl;
import org.hibernate.search.engine.search.dsl.sort.impl.ScoreSortContextImpl;
import org.hibernate.search.engine.search.dsl.sort.impl.SearchSortFactoryExtensionContextImpl;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.dsl.sort.spi.StaticNonEmptySortContext;
import org.hibernate.search.engine.spatial.GeoPoint;

public class DefaultSearchSortFactoryContext<B>
implements SearchSortFactoryContext {
    private final SearchSortDslContext<?, B> dslContext;

    public DefaultSearchSortFactoryContext(SearchSortDslContext<?, B> dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public ScoreSortContext byScore() {
        return new ScoreSortContextImpl<B>(this.dslContext);
    }

    @Override
    public NonEmptySortContext byIndexOrder() {
        return this.staticNonEmptyContext(this.dslContext.getFactory().indexOrder());
    }

    @Override
    public FieldSortContext byField(String absoluteFieldPath) {
        return new FieldSortContextImpl<B>(this.dslContext, absoluteFieldPath);
    }

    @Override
    public DistanceSortContext byDistance(String absoluteFieldPath, GeoPoint location) {
        return new DistanceSortContextImpl<B>(this.dslContext, absoluteFieldPath, location);
    }

    @Override
    public CompositeSortContext byComposite() {
        return new CompositeSortContextImpl<B>(this.dslContext);
    }

    @Override
    public NonEmptySortContext byComposite(Consumer<? super CompositeSortContext> elementContributor) {
        CompositeSortContext context = this.byComposite();
        elementContributor.accept(context);
        return context;
    }

    @Override
    public <T> T extension(SearchSortFactoryContextExtension<T> extension) {
        return DslExtensionState.returnIfSupported(extension, extension.extendOptional(this, this.dslContext));
    }

    @Override
    public SearchSortFactoryExtensionContext extension() {
        return new SearchSortFactoryExtensionContextImpl<B>(this, this.dslContext);
    }

    private NonEmptySortContext staticNonEmptyContext(B builder) {
        return new StaticNonEmptySortContext<B>(this.dslContext, builder);
    }
}

