/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.sort.impl;

import java.util.function.Function;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.dsl.sort.NonEmptySortContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryContextExtension;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryExtensionContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortTerminalContext;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.dsl.sort.spi.StaticNonEmptySortContext;

final class SearchSortFactoryExtensionContextImpl<B>
implements SearchSortFactoryExtensionContext {
    private final SearchSortFactoryContext parent;
    private final SearchSortDslContext<?, B> dslContext;
    private final DslExtensionState<SearchSortTerminalContext> state = new DslExtensionState();

    SearchSortFactoryExtensionContextImpl(SearchSortFactoryContext parent, SearchSortDslContext<?, B> dslContext) {
        this.parent = parent;
        this.dslContext = dslContext;
    }

    @Override
    public <T> SearchSortFactoryExtensionContext ifSupported(SearchSortFactoryContextExtension<T> extension, Function<T, ? extends SearchSortTerminalContext> sortContributor) {
        this.state.ifSupported(extension, extension.extendOptional(this.parent, this.dslContext), sortContributor);
        return this;
    }

    @Override
    public NonEmptySortContext orElse(Function<SearchSortFactoryContext, ? extends SearchSortTerminalContext> sortContributor) {
        SearchSortTerminalContext result = this.state.orElse(this.parent, sortContributor);
        return new StaticNonEmptySortContext<B>(this.dslContext, this.dslContext.getFactory().toImplementation(result.toSort()));
    }

    @Override
    public NonEmptySortContext orElseFail() {
        SearchSortTerminalContext result = this.state.orElseFail();
        return new StaticNonEmptySortContext<B>(this.dslContext, this.dslContext.getFactory().toImplementation(result.toSort()));
    }
}

