/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.loading.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.loading.spi.ReferenceHitMapper;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class DefaultProjectionHitMapper<R, E>
implements ProjectionHitMapper<R, E> {
    private final ReferenceHitMapper<R> referenceHitMapper;
    private final EntityLoader<R, ? extends E> objectLoader;
    private final List<R> referencesToLoad = new ArrayList<R>();

    public DefaultProjectionHitMapper(ReferenceHitMapper<R> referenceHitMapper, EntityLoader<R, ? extends E> objectLoader) {
        this.referenceHitMapper = referenceHitMapper;
        this.objectLoader = objectLoader;
    }

    @Override
    public R convertReference(DocumentReference reference) {
        return this.referenceHitMapper.fromDocumentReference(reference);
    }

    @Override
    public Object planLoading(DocumentReference reference) {
        this.referencesToLoad.add(this.referenceHitMapper.fromDocumentReference(reference));
        return this.referencesToLoad.size() - 1;
    }

    @Override
    public LoadingResult<E> loadBlocking() {
        return new DefaultLoadingResult(this.objectLoader.loadBlocking(this.referencesToLoad));
    }

    private static class DefaultLoadingResult<E>
    implements LoadingResult<E> {
        private final List<? extends E> loadedObjects;

        private DefaultLoadingResult(List<? extends E> loadedObjects) {
            this.loadedObjects = CollectionHelper.toImmutableList(loadedObjects);
        }

        @Override
        public E getLoaded(Object key) {
            return this.loadedObjects.get((Integer)key);
        }
    }
}

