/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.engine.search.sort.spi;

import org.hibernate.search.engine.search.predicate.DslConverter;

public interface FieldSortBuilder<B> extends SearchSortBuilder<B> {

	void missingFirst();

	void missingLast();

	void missingAs(Object value, DslConverter dslConverter);

}
