/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.projection;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.projection.CompositeProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.DistanceToFieldProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.DocumentReferenceProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.EntityProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.EntityReferenceProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.FieldProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.ProjectionFinalStep;
import org.hibernate.search.engine.search.dsl.projection.ScoreProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryExtension;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryExtensionIfSupportedStep;
import org.hibernate.search.engine.search.projection.ProjectionConverter;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.function.TriFunction;

public interface SearchProjectionFactory<R, E> {
    public DocumentReferenceProjectionOptionsStep documentReference();

    public EntityReferenceProjectionOptionsStep<R> entityReference();

    public EntityProjectionOptionsStep<E> entity();

    default public <T> FieldProjectionOptionsStep<T> field(String absoluteFieldPath, Class<T> type) {
        return this.field(absoluteFieldPath, type, ProjectionConverter.ENABLED);
    }

    public <T> FieldProjectionOptionsStep<T> field(String var1, Class<T> var2, ProjectionConverter var3);

    default public FieldProjectionOptionsStep<Object> field(String absoluteFieldPath) {
        return this.field(absoluteFieldPath, ProjectionConverter.ENABLED);
    }

    public FieldProjectionOptionsStep<Object> field(String var1, ProjectionConverter var2);

    public ScoreProjectionOptionsStep score();

    public DistanceToFieldProjectionOptionsStep distance(String var1, GeoPoint var2);

    default public CompositeProjectionOptionsStep<List<?>> composite(SearchProjection<?> ... projections) {
        return this.composite(Function.identity(), projections);
    }

    default public CompositeProjectionOptionsStep<List<?>> composite(ProjectionFinalStep<?> ... dslFinalSteps) {
        return this.composite(Function.identity(), dslFinalSteps);
    }

    public <T> CompositeProjectionOptionsStep<T> composite(Function<List<?>, T> var1, SearchProjection<?> ... var2);

    default public <T> CompositeProjectionOptionsStep<T> composite(Function<List<?>, T> transformer, ProjectionFinalStep<?> ... dslFinalSteps) {
        SearchProjection[] projections = new SearchProjection[dslFinalSteps.length];
        for (int i = 0; i < dslFinalSteps.length; ++i) {
            projections[i] = dslFinalSteps[i].toProjection();
        }
        return this.composite(transformer, projections);
    }

    public <P, T> CompositeProjectionOptionsStep<T> composite(Function<P, T> var1, SearchProjection<P> var2);

    default public <P, T> CompositeProjectionOptionsStep<T> composite(Function<P, T> transformer, ProjectionFinalStep<P> dslFinalStep) {
        return this.composite(transformer, dslFinalStep.toProjection());
    }

    public <P1, P2, T> CompositeProjectionOptionsStep<T> composite(BiFunction<P1, P2, T> var1, SearchProjection<P1> var2, SearchProjection<P2> var3);

    default public <P1, P2, T> CompositeProjectionOptionsStep<T> composite(BiFunction<P1, P2, T> transformer, ProjectionFinalStep<P1> dslFinalStep1, ProjectionFinalStep<P2> dslFinalStep2) {
        return this.composite(transformer, dslFinalStep1.toProjection(), dslFinalStep2.toProjection());
    }

    public <P1, P2, P3, T> CompositeProjectionOptionsStep<T> composite(TriFunction<P1, P2, P3, T> var1, SearchProjection<P1> var2, SearchProjection<P2> var3, SearchProjection<P3> var4);

    default public <P1, P2, P3, T> CompositeProjectionOptionsStep<T> composite(TriFunction<P1, P2, P3, T> transformer, ProjectionFinalStep<P1> dslFinalStep1, ProjectionFinalStep<P2> dslFinalStep2, ProjectionFinalStep<P3> dslFinalStep3) {
        return this.composite(transformer, dslFinalStep1.toProjection(), dslFinalStep2.toProjection(), dslFinalStep3.toProjection());
    }

    public <T> T extension(SearchProjectionFactoryExtension<T, R, E> var1);

    public <T> SearchProjectionFactoryExtensionIfSupportedStep<T, R, E> extension();
}

