/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.projection.impl;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.projection.CompositeProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.DistanceToFieldProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.DocumentReferenceProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.EntityProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.EntityReferenceProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.FieldProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.ScoreProjectionOptionsStep;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactory;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryExtension;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryExtensionIfSupportedStep;
import org.hibernate.search.engine.search.dsl.projection.impl.CompositeProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.DistanceToFieldProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.DocumentReferenceProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.EntityProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.EntityReferenceProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.FieldProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.ScoreProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.dsl.projection.impl.SearchProjectionFactoryExtensionStep;
import org.hibernate.search.engine.search.projection.ProjectionConverter;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.function.TriFunction;
import org.hibernate.search.util.common.impl.Contracts;

public class DefaultSearchProjectionFactory<R, E>
implements SearchProjectionFactory<R, E> {
    private final SearchProjectionBuilderFactory factory;

    public DefaultSearchProjectionFactory(SearchProjectionBuilderFactory factory) {
        this.factory = factory;
    }

    @Override
    public DocumentReferenceProjectionOptionsStep documentReference() {
        return new DocumentReferenceProjectionOptionsStepImpl(this.factory);
    }

    @Override
    public <T> FieldProjectionOptionsStep<T> field(String absoluteFieldPath, Class<T> clazz, ProjectionConverter projectionConverter) {
        Contracts.assertNotNull(clazz, (String)"clazz");
        return new FieldProjectionOptionsStepImpl<T>(this.factory, absoluteFieldPath, clazz, projectionConverter);
    }

    @Override
    public FieldProjectionOptionsStep<Object> field(String absoluteFieldPath, ProjectionConverter projectionConverter) {
        return this.field(absoluteFieldPath, Object.class, projectionConverter);
    }

    @Override
    public EntityReferenceProjectionOptionsStep<R> entityReference() {
        return new EntityReferenceProjectionOptionsStepImpl(this.factory);
    }

    @Override
    public EntityProjectionOptionsStep<E> entity() {
        return new EntityProjectionOptionsStepImpl(this.factory);
    }

    @Override
    public ScoreProjectionOptionsStep score() {
        return new ScoreProjectionOptionsStepImpl(this.factory);
    }

    @Override
    public DistanceToFieldProjectionOptionsStep distance(String absoluteFieldPath, GeoPoint center) {
        Contracts.assertNotNull((Object)center, (String)"center");
        return new DistanceToFieldProjectionOptionsStepImpl(this.factory, absoluteFieldPath, center);
    }

    @Override
    public <T> CompositeProjectionOptionsStep<T> composite(Function<List<?>, T> transformer, SearchProjection<?> ... projections) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNullNorEmpty((Object[])projections, (String)"projections");
        return new CompositeProjectionOptionsStepImpl<T>(this.factory, transformer, projections);
    }

    @Override
    public <P, T> CompositeProjectionOptionsStep<T> composite(Function<P, T> transformer, SearchProjection<P> projection) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection, (String)"projection");
        return new CompositeProjectionOptionsStepImpl<T>(this.factory, transformer, projection);
    }

    @Override
    public <P1, P2, T> CompositeProjectionOptionsStep<T> composite(BiFunction<P1, P2, T> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection1, (String)"projection1");
        Contracts.assertNotNull(projection2, (String)"projection2");
        return new CompositeProjectionOptionsStepImpl<T>(this.factory, transformer, projection1, projection2);
    }

    @Override
    public <P1, P2, P3, T> CompositeProjectionOptionsStep<T> composite(TriFunction<P1, P2, P3, T> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection1, (String)"projection1");
        Contracts.assertNotNull(projection2, (String)"projection2");
        Contracts.assertNotNull(projection3, (String)"projection3");
        return new CompositeProjectionOptionsStepImpl<T>(this.factory, transformer, projection1, projection2, projection3);
    }

    @Override
    public <T> T extension(SearchProjectionFactoryExtension<T, R, E> extension) {
        return DslExtensionState.returnIfSupported(extension, extension.extendOptional(this, this.factory));
    }

    @Override
    public <T> SearchProjectionFactoryExtensionIfSupportedStep<T, R, E> extension() {
        return new SearchProjectionFactoryExtensionStep(this, this.factory);
    }
}

