/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.search.dsl.predicate.SpatialWithinPredicateFieldMoreStep;
import org.hibernate.search.engine.search.dsl.predicate.SpatialWithinPredicateOptionsStep;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;

class SpatialWithinPredicateFieldMoreStepImpl<B>
implements SpatialWithinPredicateFieldMoreStep,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState<B> {
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<SearchPredicateBuilder<B>> predicateBuilders;
    private Float fieldSetBoost;

    SpatialWithinPredicateFieldMoreStepImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = CollectionHelper.toImmutableList(absoluteFieldPaths);
        this.predicateBuilders = new ArrayList<SearchPredicateBuilder<B>>(absoluteFieldPaths.size());
    }

    @Override
    public SpatialWithinPredicateFieldMoreStep orFields(String ... absoluteFieldPaths) {
        return new SpatialWithinPredicateFieldMoreStepImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public SpatialWithinPredicateFieldMoreStep boostedTo(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public SpatialWithinPredicateOptionsStep circle(GeoPoint center, double radius, DistanceUnit unit) {
        Contracts.assertNotNull((Object)center, (String)"center");
        Contracts.assertNotNull((Object)radius, (String)"radius");
        Contracts.assertNotNull((Object)((Object)unit), (String)"unit");
        return this.commonState.circle(center, radius, unit);
    }

    @Override
    public SpatialWithinPredicateOptionsStep polygon(GeoPolygon polygon) {
        Contracts.assertNotNull((Object)polygon, (String)"polygon");
        return this.commonState.polygon(polygon);
    }

    @Override
    public SpatialWithinPredicateOptionsStep boundingBox(GeoBoundingBox boundingBox) {
        Contracts.assertNotNull((Object)boundingBox, (String)"boundingBox");
        return this.commonState.boundingBox(boundingBox);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (SearchPredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    private void generateWithinCircleQueryBuilders(GeoPoint center, double radius, DistanceUnit unit) {
        for (String absoluteFieldPath : this.absoluteFieldPaths) {
            SpatialWithinCirclePredicateBuilder predicateBuilder = this.commonState.getFactory().spatialWithinCircle(absoluteFieldPath);
            predicateBuilder.circle(center, radius, unit);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    private void generateWithinPolygonQueryBuilders(GeoPolygon polygon) {
        for (String absoluteFieldPath : this.absoluteFieldPaths) {
            SpatialWithinPolygonPredicateBuilder predicateBuilder = this.commonState.getFactory().spatialWithinPolygon(absoluteFieldPath);
            predicateBuilder.polygon(polygon);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    private void generateWithinBoundingBoxQueryBuilders(GeoBoundingBox boundingBox) {
        for (String absoluteFieldPath : this.absoluteFieldPaths) {
            SpatialWithinBoundingBoxPredicateBuilder predicateBuilder = this.commonState.getFactory().spatialWithinBoundingBox(absoluteFieldPath);
            predicateBuilder.boundingBox(boundingBox);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, SpatialWithinPredicateFieldMoreStepImpl<B>>
    implements SpatialWithinPredicateOptionsStep {
        CommonState(SearchPredicateBuilderFactory<?, B> builderFactory) {
            super(builderFactory);
        }

        SpatialWithinPredicateOptionsStep circle(GeoPoint center, double radius, DistanceUnit unit) {
            for (SpatialWithinPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                fieldSetState.generateWithinCircleQueryBuilders(center, radius, unit);
            }
            return this;
        }

        SpatialWithinPredicateOptionsStep polygon(GeoPolygon polygon) {
            for (SpatialWithinPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                fieldSetState.generateWithinPolygonQueryBuilders(polygon);
            }
            return this;
        }

        SpatialWithinPredicateOptionsStep boundingBox(GeoBoundingBox boundingBox) {
            for (SpatialWithinPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                fieldSetState.generateWithinBoundingBoxQueryBuilders(boundingBox);
            }
            return this;
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

