/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.spi;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.engine.cfg.ConfigurationPropertyCheckingStrategyName;
import org.hibernate.search.engine.cfg.EngineSettings;
import org.hibernate.search.engine.cfg.spi.AllAwareConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConsumedPropertyTrackingConfigurationPropertySource;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ConfigurationPropertyChecker {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<ConfigurationPropertyCheckingStrategyName> CONFIGURATION_PROPERTY_CHECKING_STRATEGY = ConfigurationProperty.forKey("hibernate.search.configuration_property_checking.strategy").as(ConfigurationPropertyCheckingStrategyName.class, ConfigurationPropertyCheckingStrategyName::of).withDefault(EngineSettings.Defaults.CONFIGURATION_PROPERTY_CHECKING_STRATEGY).build();
    private final Set<String> availablePropertyKeys = ConcurrentHashMap.newKeySet();
    private final Set<String> consumedPropertyKeys = ConcurrentHashMap.newKeySet();
    private volatile boolean warn;

    public static ConfigurationPropertyChecker create() {
        return new ConfigurationPropertyChecker();
    }

    private ConfigurationPropertyChecker() {
    }

    public ConfigurationPropertySource wrap(AllAwareConfigurationPropertySource source) {
        ConsumedPropertyTrackingConfigurationPropertySource trackingSource = new ConsumedPropertyTrackingConfigurationPropertySource(source, this::addConsumedPropertyKey);
        ConfigurationPropertyCheckingStrategyName checkingStrategy = CONFIGURATION_PROPERTY_CHECKING_STRATEGY.get(trackingSource);
        switch (checkingStrategy) {
            case WARN: {
                this.warn = true;
                this.availablePropertyKeys.addAll(source.resolveAll("hibernate.search."));
                return trackingSource;
            }
            case IGNORE: {
                return source;
            }
        }
        throw new AssertionFailure("Unexpected configuration property checking strategy name: " + (Object)((Object)checkingStrategy));
    }

    public void beforeBoot() {
        if (!this.warn) {
            log.configurationPropertyTrackingDisabled();
        }
    }

    public void afterBoot(ConfigurationPropertyChecker firstPhaseChecker, ConfigurationPropertySource propertySource) {
        if (!this.warn) {
            return;
        }
        List checkers = CollectionHelper.asImmutableList((Object[])new ConfigurationPropertyChecker[]{firstPhaseChecker, this});
        LinkedHashSet<String> unconsumedPropertyKeys = new LinkedHashSet<String>();
        for (ConfigurationPropertyChecker checker : checkers) {
            unconsumedPropertyKeys.addAll(checker.availablePropertyKeys);
        }
        for (ConfigurationPropertyChecker checker : checkers) {
            unconsumedPropertyKeys.removeAll(checker.consumedPropertyKeys);
        }
        if (!unconsumedPropertyKeys.isEmpty()) {
            log.configurationPropertyTrackingUnusedProperties(unconsumedPropertyKeys, CONFIGURATION_PROPERTY_CHECKING_STRATEGY.resolveOrRaw(propertySource), ConfigurationPropertyCheckingStrategyName.IGNORE.getExternalRepresentation());
        }
    }

    private void addConsumedPropertyKey(String key) {
        this.consumedPropertyKeys.add(key);
    }
}

