/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class IndexSchemaFilter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final IndexSchemaFilter ROOT = new IndexSchemaFilter(null, null, null, null, Collections.emptySet(), Collections.emptySet());
    private final IndexSchemaFilter parent;
    private final MappableTypeModel parentTypeModel;
    private final String relativePrefix;
    private final Integer remainingCompositionDepth;
    private final Set<String> explicitlyIncludedPaths;
    private final Set<String> properExplicitlyIncludedPaths;
    private final Map<String, Boolean> encounteredFieldPaths = new LinkedHashMap<String, Boolean>();

    public static IndexSchemaFilter root() {
        return ROOT;
    }

    private IndexSchemaFilter(IndexSchemaFilter parent, MappableTypeModel parentTypeModel, String relativePrefix, Integer remainingCompositionDepth, Set<String> explicitlyIncludedPaths, Set<String> properExplicitlyIncludedPaths) {
        this.parent = parent;
        this.parentTypeModel = parentTypeModel;
        this.relativePrefix = relativePrefix;
        this.remainingCompositionDepth = remainingCompositionDepth;
        this.explicitlyIncludedPaths = explicitlyIncludedPaths;
        this.properExplicitlyIncludedPaths = properExplicitlyIncludedPaths;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "parentTypeModel=" + this.parentTypeModel + ",relativePrefix=" + this.relativePrefix + ",remainingCompositionDepth=" + this.remainingCompositionDepth + ",explicitlyIncludedPaths=" + this.explicitlyIncludedPaths + "]";
    }

    public boolean isPathIncluded(String relativePath) {
        boolean included = IndexSchemaFilter.isPathIncluded(this.remainingCompositionDepth, this.explicitlyIncludedPaths, relativePath);
        this.markAsEncountered(relativePath, included);
        return included;
    }

    private void markAsEncountered(String relativePath, boolean included) {
        this.encounteredFieldPaths.put(relativePath, included);
        if (this.parent != null) {
            this.parent.markAsEncountered(this.relativePrefix + relativePath, included);
        }
    }

    public boolean isEveryPathExcluded() {
        return !IndexSchemaFilter.isEveryPathIncludedByDefault(this.remainingCompositionDepth) && !this.isAnyPathExplicitlyIncluded();
    }

    public Set<String> getProperExplicitlyIncludedPaths() {
        return this.properExplicitlyIncludedPaths;
    }

    public Map<String, Boolean> getEncounteredFieldPaths() {
        return this.encounteredFieldPaths;
    }

    private String getPathFromSameIndexedEmbeddedSinceNoCompositionLimits(MappableTypeModel parentTypeModel, String relativePrefix) {
        if (this.hasCompositionLimits()) {
            return null;
        }
        if (this.parent != null) {
            if (this.relativePrefix.equals(relativePrefix) && this.parentTypeModel.isSubTypeOf(parentTypeModel)) {
                return this.relativePrefix;
            }
            String path = this.parent.getPathFromSameIndexedEmbeddedSinceNoCompositionLimits(parentTypeModel, relativePrefix);
            return path == null ? null : path + this.relativePrefix;
        }
        return null;
    }

    public IndexSchemaFilter composeWithNested(MappableTypeModel parentTypeModel, String relativePrefix, Integer maxDepth, Set<String> includePaths) {
        Integer composedRemainingDepth;
        String cyclicRecursionPath = this.getPathFromSameIndexedEmbeddedSinceNoCompositionLimits(parentTypeModel, relativePrefix);
        if (cyclicRecursionPath != null) {
            cyclicRecursionPath = cyclicRecursionPath + relativePrefix;
            throw log.indexedEmbeddedCyclicRecursion(cyclicRecursionPath, parentTypeModel);
        }
        Set<Object> nullSafeIncludePaths = includePaths == null ? Collections.emptySet() : includePaths;
        Integer currentRemainingDepth = this.remainingCompositionDepth == null ? null : Integer.valueOf(this.remainingCompositionDepth - 1);
        Integer nestedRemainingDepth = maxDepth;
        if (maxDepth == null && !nullSafeIncludePaths.isEmpty()) {
            nestedRemainingDepth = 0;
        }
        if ((composedRemainingDepth = currentRemainingDepth) == null || nestedRemainingDepth != null && composedRemainingDepth > nestedRemainingDepth) {
            composedRemainingDepth = nestedRemainingDepth;
        }
        HashSet<String> composedFilterExplicitlyIncludedPaths = new HashSet<String>();
        LinkedHashSet<String> composedFilterProperExplicitlyIncludedPaths = new LinkedHashSet<String>();
        for (String string : nullSafeIncludePaths) {
            if (!IndexSchemaFilter.isPathIncluded(currentRemainingDepth, this.explicitlyIncludedPaths, relativePrefix + string)) continue;
            composedFilterExplicitlyIncludedPaths.add(string);
            composedFilterProperExplicitlyIncludedPaths.add(string);
            int afterPreviousDotIndex = 0;
            int nextDotIndex = string.indexOf(46, afterPreviousDotIndex);
            while (nextDotIndex >= 0) {
                String subPath = string.substring(0, nextDotIndex);
                composedFilterExplicitlyIncludedPaths.add(subPath);
                afterPreviousDotIndex = nextDotIndex + 1;
                nextDotIndex = string.indexOf(46, afterPreviousDotIndex);
            }
        }
        int relativePrefixLength = relativePrefix.length();
        for (String path : this.explicitlyIncludedPaths) {
            String pathRelativeToNestedFilter;
            if (!path.startsWith(relativePrefix) || !IndexSchemaFilter.isPathIncluded(nestedRemainingDepth, nullSafeIncludePaths, pathRelativeToNestedFilter = path.substring(relativePrefixLength))) continue;
            composedFilterExplicitlyIncludedPaths.add(pathRelativeToNestedFilter);
        }
        return new IndexSchemaFilter(this, parentTypeModel, relativePrefix, composedRemainingDepth, composedFilterExplicitlyIncludedPaths, composedFilterProperExplicitlyIncludedPaths);
    }

    private static boolean isPathIncluded(Integer remainingDepth, Set<String> explicitlyIncludedPaths, String relativePath) {
        return IndexSchemaFilter.isEveryPathIncludedByDefault(remainingDepth) || explicitlyIncludedPaths.contains(relativePath);
    }

    private static boolean isEveryPathIncludedByDefault(Integer remainingDepth) {
        return remainingDepth == null || remainingDepth > 0;
    }

    private boolean isAnyPathExplicitlyIncluded() {
        return !this.explicitlyIncludedPaths.isEmpty();
    }

    private boolean hasCompositionLimits() {
        return this.remainingCompositionDepth != null || !this.explicitlyIncludedPaths.isEmpty();
    }
}

