/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.ToStringStyle;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.EventContextElement;
import org.hibernate.search.util.common.reporting.impl.CommonEventContextMessages;
import org.jboss.logging.Messages;

public class RootFailureCollector
implements FailureCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final CommonEventContextMessages COMMON_MESSAGES = (CommonEventContextMessages)Messages.getBundle(CommonEventContextMessages.class);
    private static final EngineEventContextMessages ENGINE_MESSAGES = (EngineEventContextMessages)Messages.getBundle(EngineEventContextMessages.class);
    private final int failureLimit;
    private NonRootFailureCollector delegate;
    private int failureCount = 0;

    public RootFailureCollector(int failureLimit) {
        this.failureLimit = failureLimit;
    }

    public void checkNoFailure() {
        if (this.failureCount > 0) {
            String renderedFailures = this.renderFailures();
            throw log.bootstrapCollectedFailures(renderedFailures);
        }
    }

    private String renderFailures() {
        ToStringStyle style = ToStringStyle.multilineIndentStructure((String)ENGINE_MESSAGES.failureReportContextFailuresSeparator(), (String)ENGINE_MESSAGES.failureReportContextIndent(), (String)ENGINE_MESSAGES.failureReportFailuresBulletPoint(), (String)ENGINE_MESSAGES.failureReportFailuresNoBulletPoint());
        ToStringTreeBuilder builder = new ToStringTreeBuilder(style);
        if (this.delegate != null) {
            this.delegate.appendFailuresTo(builder);
        }
        return builder.toString();
    }

    @Override
    public ContextualFailureCollector withContext(EventContext context) {
        if (this.delegate == null) {
            this.delegate = new NonRootFailureCollector(this);
        }
        return this.delegate.withContext(context);
    }

    @Override
    public ContextualFailureCollector withContext(EventContextElement contextElement) {
        if (this.delegate == null) {
            this.delegate = new NonRootFailureCollector(this);
        }
        return this.delegate.withContext(contextElement);
    }

    private void onAddFailure() {
        ++this.failureCount;
        if (this.failureCount >= this.failureLimit) {
            String renderedFailures = this.renderFailures();
            throw log.boostrapCollectedFailureLimitReached(renderedFailures, this.failureCount);
        }
    }

    private static class ContextualFailureCollectorImpl
    extends NonRootFailureCollector
    implements ContextualFailureCollector {
        private final NonRootFailureCollector parent;
        private final EventContextElement context;
        private List<String> failureMessages;

        private ContextualFailureCollectorImpl(NonRootFailureCollector parent, EventContextElement context) {
            super(parent);
            this.parent = parent;
            this.context = context;
        }

        @Override
        public boolean hasFailure() {
            if (this.failureMessages != null && !this.failureMessages.isEmpty()) {
                return true;
            }
            for (ContextualFailureCollectorImpl child : this.getChildren().values()) {
                if (!child.hasFailure()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void add(Throwable t) {
            if (t instanceof SearchException) {
                SearchException e = (SearchException)t;
                ContextualFailureCollectorImpl failureCollector = this;
                EventContext eventContext = e.getContext();
                if (eventContext != null) {
                    failureCollector = failureCollector.withContext(e.getContext());
                }
                failureCollector.doAdd(e, e.getMessageWithoutContext());
            } else {
                this.doAdd(t, t.getMessage());
            }
        }

        @Override
        public void add(String failureMessage) {
            this.doAdd(failureMessage);
        }

        @Override
        ContextualFailureCollectorImpl withDefaultContext() {
            return this;
        }

        @Override
        void appendContextTo(StringJoiner joiner) {
            this.parent.appendContextTo(joiner);
            joiner.add(this.context.render());
        }

        @Override
        void appendFailuresTo(ToStringTreeBuilder builder) {
            builder.startObject(this.context.render());
            if (this.failureMessages != null) {
                builder.startList(ENGINE_MESSAGES.failureReportFailures());
                for (String failureMessage : this.failureMessages) {
                    builder.value((Object)failureMessage);
                }
                builder.endList();
            }
            this.appendChildrenFailuresTo(builder);
            builder.endObject();
        }

        private void doAdd(Throwable failure, String failureMessage) {
            StringJoiner contextJoiner = new StringJoiner(COMMON_MESSAGES.contextSeparator());
            this.appendContextTo(contextJoiner);
            log.newBootstrapCollectedFailure(contextJoiner.toString(), failure);
            this.doAdd(failureMessage);
        }

        private void doAdd(String failureMessage) {
            if (this.failureMessages == null) {
                this.failureMessages = new ArrayList<String>();
            }
            this.failureMessages.add(failureMessage);
            this.root.onAddFailure();
        }
    }

    private static class NonRootFailureCollector
    implements FailureCollector {
        protected final RootFailureCollector root;
        private Map<EventContextElement, ContextualFailureCollectorImpl> children;

        private NonRootFailureCollector(RootFailureCollector root) {
            this.root = root;
        }

        protected NonRootFailureCollector(NonRootFailureCollector parent) {
            this.root = parent.root;
        }

        @Override
        public ContextualFailureCollectorImpl withContext(EventContext context) {
            List elements = context.getElements();
            if (elements.isEmpty()) {
                log.unexpectedEmptyEventContext(new IllegalStateException("Exception for stack trace"));
                return this.withDefaultContext();
            }
            NonRootFailureCollector failureCollector = this;
            for (EventContextElement contextElement : elements) {
                failureCollector = failureCollector.withContext(contextElement);
            }
            return (ContextualFailureCollectorImpl)failureCollector;
        }

        @Override
        public ContextualFailureCollectorImpl withContext(EventContextElement contextElement) {
            ContextualFailureCollectorImpl child;
            if (this.children == null) {
                this.children = new LinkedHashMap<EventContextElement, ContextualFailureCollectorImpl>();
            }
            if ((child = this.children.get(contextElement)) != null) {
                return child;
            }
            child = new ContextualFailureCollectorImpl(this, contextElement);
            this.children.put(contextElement, child);
            return child;
        }

        ContextualFailureCollectorImpl withDefaultContext() {
            return this.withContext(EventContexts.getDefault());
        }

        void appendContextTo(StringJoiner joiner) {
        }

        void appendFailuresTo(ToStringTreeBuilder builder) {
            builder.startObject();
            this.appendChildrenFailuresTo(builder);
            builder.endObject();
        }

        final void appendChildrenFailuresTo(ToStringTreeBuilder builder) {
            if (this.children != null) {
                for (ContextualFailureCollectorImpl child : this.children.values()) {
                    if (!child.hasFailure()) continue;
                    child.appendFailuresTo(builder);
                }
            }
        }

        final Map<EventContextElement, ContextualFailureCollectorImpl> getChildren() {
            return this.children != null ? this.children : Collections.emptyMap();
        }
    }
}

