/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFromToStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateLastLimitExcludeStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class RangePredicateFieldMoreStepImpl<B>
implements RangePredicateFieldMoreStep<RangePredicateFieldMoreStepImpl<B>, RangePredicateOptionsStep<?>>,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<RangePredicateBuilder<B>> predicateBuilders = new ArrayList<RangePredicateBuilder<B>>();
    private Float fieldSetBoost;

    RangePredicateFieldMoreStepImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.range(absoluteFieldPath));
        }
    }

    @Override
    public RangePredicateFieldMoreStepImpl<B> fields(String ... absoluteFieldPaths) {
        return new RangePredicateFieldMoreStepImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public RangePredicateFieldMoreStepImpl<B> boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public RangePredicateOptionsStep<?> range(Range<?> range, ValueConvert convert) {
        return this.commonState.range(range, convert, convert);
    }

    @Override
    public RangePredicateFromToStep from(Object value, ValueConvert convert) {
        this.commonState.getOrCreateLegacySyntaxState().lowerBoundValue = value;
        this.commonState.getOrCreateLegacySyntaxState().lowerBoundConvert = convert;
        return new RangePredicateFromToStepImpl<B>(this.commonState);
    }

    @Override
    public RangePredicateLastLimitExcludeStep above(Object value, ValueConvert convert) {
        this.commonState.getOrCreateLegacySyntaxState().lowerBoundValue = value;
        this.commonState.getOrCreateLegacySyntaxState().lowerBoundConvert = convert;
        return new RangePredicateSingleLimitExcludeStep<B>(this.commonState, false);
    }

    @Override
    public RangePredicateLastLimitExcludeStep below(Object value, ValueConvert convert) {
        this.commonState.getOrCreateLegacySyntaxState().upperBoundValue = value;
        this.commonState.getOrCreateLegacySyntaxState().upperBoundConvert = convert;
        return new RangePredicateSingleLimitExcludeStep<B>(this.commonState, true);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (RangePredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    private static class LegacySyntaxState {
        private Object lowerBoundValue = null;
        private RangeBoundInclusion lowerBoundInclusion = RangeBoundInclusion.INCLUDED;
        private ValueConvert lowerBoundConvert = ValueConvert.YES;
        private Object upperBoundValue = null;
        private RangeBoundInclusion upperBoundInclusion = RangeBoundInclusion.INCLUDED;
        private ValueConvert upperBoundConvert = ValueConvert.YES;

        private LegacySyntaxState() {
        }

        public <B> void contribute(CommonState<B> commonState) {
            commonState.range(Range.between((Object)this.lowerBoundValue, (RangeBoundInclusion)this.lowerBoundInclusion, (Object)this.upperBoundValue, (RangeBoundInclusion)this.upperBoundInclusion), this.lowerBoundConvert, this.upperBoundConvert);
        }
    }

    static class RangePredicateSingleLimitExcludeStep<B>
    implements RangePredicateLastLimitExcludeStep {
        private final CommonState<B> commonState;
        private final boolean isUpperBound;

        RangePredicateSingleLimitExcludeStep(CommonState<B> commonState, boolean isUpperBound) {
            this.commonState = commonState;
            this.isUpperBound = isUpperBound;
        }

        @Override
        public RangePredicateOptionsStep<?> boost(float boost) {
            this.commonState.boost(boost);
            return this;
        }

        @Override
        public RangePredicateOptionsStep<?> excludeLimit() {
            if (this.isUpperBound) {
                this.commonState.getOrCreateLegacySyntaxState().upperBoundInclusion = RangeBoundInclusion.EXCLUDED;
            } else {
                this.commonState.getOrCreateLegacySyntaxState().lowerBoundInclusion = RangeBoundInclusion.EXCLUDED;
            }
            return this;
        }

        @Override
        public SearchPredicate toPredicate() {
            return this.commonState.toPredicate();
        }
    }

    static class RangePredicateFromToStepImpl<B>
    implements RangePredicateFromToStep {
        private final CommonState<B> commonState;

        RangePredicateFromToStepImpl(CommonState<B> commonState) {
            this.commonState = commonState;
        }

        @Override
        public RangePredicateLastLimitExcludeStep to(Object value, ValueConvert convert) {
            this.commonState.getOrCreateLegacySyntaxState().upperBoundValue = value;
            this.commonState.getOrCreateLegacySyntaxState().upperBoundConvert = convert;
            return new RangePredicateSingleLimitExcludeStep<B>(this.commonState, true);
        }

        @Override
        public RangePredicateFromToStep excludeLimit() {
            this.commonState.getOrCreateLegacySyntaxState().lowerBoundInclusion = RangeBoundInclusion.EXCLUDED;
            return this;
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, RangePredicateFieldMoreStepImpl<B>>
    implements RangePredicateOptionsStep<CommonState<B>> {
        private LegacySyntaxState legacySyntaxState;

        CommonState(SearchPredicateBuilderFactory<?, B> builderFactory) {
            super(builderFactory);
        }

        CommonState<B> range(Range<?> range, ValueConvert lowerBoundConvert, ValueConvert upperBoundConvert) {
            Contracts.assertNotNull(range, (String)"range");
            if (!range.getLowerBoundValue().isPresent() && !range.getUpperBoundValue().isPresent()) {
                throw log.rangePredicateCannotMatchNullValue(this.getEventContext());
            }
            for (RangePredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (RangePredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.range(range, lowerBoundConvert, upperBoundConvert);
                }
            }
            return this;
        }

        LegacySyntaxState getOrCreateLegacySyntaxState() {
            if (this.legacySyntaxState == null) {
                this.legacySyntaxState = new LegacySyntaxState();
            }
            return this.legacySyntaxState;
        }

        @Override
        protected B toImplementation() {
            if (this.legacySyntaxState != null) {
                this.legacySyntaxState.contribute(this);
            }
            return super.toImplementation();
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

