/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spatial;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.ImmutableGeoPolygon;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;

public interface GeoPolygon {
    public List<GeoPoint> getPoints();

    public static GeoPolygon of(List<GeoPoint> points) {
        Contracts.assertNotNull(points, (String)"points");
        return new ImmutableGeoPolygon(CollectionHelper.toImmutableList(new ArrayList<GeoPoint>(points)));
    }

    public static GeoPolygon of(GeoPoint firstPoint, GeoPoint secondPoint, GeoPoint thirdPoint, GeoPoint fourthPoint, GeoPoint ... additionalPoints) {
        Contracts.assertNotNull((Object)firstPoint, (String)"firstPoint");
        Contracts.assertNotNull((Object)secondPoint, (String)"secondPoint");
        Contracts.assertNotNull((Object)thirdPoint, (String)"thirdPoint");
        Contracts.assertNotNull((Object)fourthPoint, (String)"fourthPoint");
        Contracts.assertNotNull((Object)additionalPoints, (String)"additionalPoints");
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>();
        points.add(firstPoint);
        points.add(secondPoint);
        points.add(thirdPoint);
        points.add(fourthPoint);
        Collections.addAll(points, additionalPoints);
        return new ImmutableGeoPolygon(CollectionHelper.toImmutableList(points));
    }
}

