/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.engine.cfg.EngineSettings;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.EngineSpiSettings;
import org.hibernate.search.engine.common.impl.IndexManagerBuildingStateHolder;
import org.hibernate.search.engine.common.impl.MappedIndexManagerFactoryImpl;
import org.hibernate.search.engine.common.impl.MappingBuildContextImpl;
import org.hibernate.search.engine.common.impl.RootBuildContext;
import org.hibernate.search.engine.common.impl.SearchIntegrationPartialBuildStateImpl;
import org.hibernate.search.engine.common.resources.impl.EngineThreads;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.common.timing.impl.DefaultTimingSource;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.impl.ConfiguredBeanResolver;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.bean.spi.ReflectionBeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.AggregatedClassLoader;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultServiceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.hibernate.search.engine.environment.thread.impl.ThreadPoolProviderImpl;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerFactory;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingAbortedException;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataDiscoverer;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.impl.FailSafeFailureHandlerWrapper;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class SearchIntegrationBuilderImpl
implements SearchIntegrationBuilder {
    private static final ConfigurationProperty<BeanReference<? extends FailureHandler>> BACKGROUND_FAILURE_HANDLER = ConfigurationProperty.forKey("background_failure_handler").asBeanReference(FailureHandler.class).withDefault(EngineSettings.Defaults.BACKGROUND_FAILURE_HANDLER).build();
    private static final ConfigurationProperty<BeanReference<? extends ThreadProvider>> THREAD_PROVIDER = ConfigurationProperty.forKey("thread_provider").asBeanReference(ThreadProvider.class).withDefault(EngineSpiSettings.Defaults.THREAD_PROVIDER).build();
    private final ConfigurationPropertyChecker propertyChecker;
    private final ConfigurationPropertySource propertySource;
    private final Map<MappingKey<?, ?>, MappingInitiator<?, ?>> mappingInitiators = new LinkedHashMap();
    private ClassResolver classResolver;
    private ResourceResolver resourceResolver;
    private ServiceResolver serviceResolver;
    private BeanProvider beanProvider;
    private boolean frozen = false;

    public SearchIntegrationBuilderImpl(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker propertyChecker) {
        this.propertyChecker = propertyChecker;
        this.propertySource = propertySource.withMask("hibernate.search");
        propertyChecker.beforeBoot();
    }

    @Override
    public ConfigurationPropertySource maskedPropertySource() {
        return this.propertySource;
    }

    @Override
    public SearchIntegrationBuilder classResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder resourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder serviceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder beanProvider(BeanProvider beanProvider) {
        this.beanProvider = beanProvider;
        return this;
    }

    @Override
    public <PBM extends MappingPartialBuildState> SearchIntegrationBuilder addMappingInitiator(MappingKey<PBM, ?> mappingKey, MappingInitiator<?, PBM> initiator) {
        if (this.frozen) {
            throw new AssertionFailure("Attempt to add a mapping initiator after Hibernate Search has started to build the mappings. There is a bug in the Hibernate Search integration.");
        }
        MappingInitiator<?, PBM> existing = this.mappingInitiators.putIfAbsent(mappingKey, initiator);
        if (existing != null) {
            throw new AssertionFailure("Mapping key '" + mappingKey + "' has multiple initiators: '" + existing + "', '" + initiator + "'. There is a bug in the mapper, please report it.");
        }
        return this;
    }

    @Override
    public SearchIntegrationPartialBuildState prepareBuild() {
        BeanHolder<FailSafeFailureHandlerWrapper> failureHandlerHolder = null;
        BeanHolder threadProviderHolder = null;
        IndexManagerBuildingStateHolder indexManagerBuildingStateHolder = null;
        ArrayList<MappingBuildingState> mappingBuildingStates = new ArrayList<MappingBuildingState>();
        HashMap partiallyBuiltMappings = new HashMap();
        RootFailureCollector failureCollector = new RootFailureCollector(EngineEventContextMessages.INSTANCE.bootstrap());
        boolean checkingRootFailures = false;
        EngineThreads engineThreads = null;
        DefaultTimingSource timingSource = null;
        try {
            this.frozen = true;
            AggregatedClassLoader aggregatedClassLoader = null;
            if (this.classResolver == null) {
                aggregatedClassLoader = AggregatedClassLoader.createDefault();
                this.classResolver = DefaultClassResolver.create(aggregatedClassLoader);
            }
            if (this.resourceResolver == null) {
                if (aggregatedClassLoader == null) {
                    aggregatedClassLoader = AggregatedClassLoader.createDefault();
                }
                this.resourceResolver = DefaultResourceResolver.create(aggregatedClassLoader);
            }
            if (this.serviceResolver == null) {
                if (aggregatedClassLoader == null) {
                    aggregatedClassLoader = AggregatedClassLoader.createDefault();
                }
                this.serviceResolver = DefaultServiceResolver.create(aggregatedClassLoader);
            }
            if (this.beanProvider == null) {
                this.beanProvider = ReflectionBeanProvider.create(this.classResolver);
            }
            ConfiguredBeanResolver beanResolver = new ConfiguredBeanResolver(this.serviceResolver, this.beanProvider, this.propertySource);
            failureHandlerHolder = BACKGROUND_FAILURE_HANDLER.getAndTransform(this.propertySource, beanResolver::resolve);
            failureHandlerHolder = BeanHolder.of(new FailSafeFailureHandlerWrapper((FailureHandler)failureHandlerHolder.get())).withDependencyAutoClosing(failureHandlerHolder);
            FailureHandler failureHandler = failureHandlerHolder.get();
            threadProviderHolder = THREAD_PROVIDER.getAndTransform(this.propertySource, beanResolver::resolve);
            ThreadPoolProviderImpl threadPoolProvider = new ThreadPoolProviderImpl(threadProviderHolder);
            engineThreads = new EngineThreads(threadPoolProvider);
            timingSource = new DefaultTimingSource(engineThreads);
            RootBuildContext rootBuildContext = new RootBuildContext(this.propertySource, this.classResolver, this.resourceResolver, beanResolver, failureCollector, threadPoolProvider, failureHandler, engineThreads, timingSource);
            indexManagerBuildingStateHolder = new IndexManagerBuildingStateHolder(beanResolver, this.propertySource, rootBuildContext);
            for (Map.Entry<MappingKey<?, ?>, MappingInitiator<?, ?>> entry : this.mappingInitiators.entrySet()) {
                MappingBuildingState mappingBuildingState = new MappingBuildingState(rootBuildContext, entry.getKey(), entry.getValue());
                mappingBuildingStates.add(mappingBuildingState);
                mappingBuildingState.collect();
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.createMapper();
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            LinkedHashSet<Optional<String>> backendNames = new LinkedHashSet<Optional<String>>();
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.determineIndexedTypes(backendNames);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            indexManagerBuildingStateHolder.createBackends(backendNames);
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            MappedIndexManagerFactoryImpl mappedIndexManagerFactoryImpl = new MappedIndexManagerFactoryImpl(indexManagerBuildingStateHolder);
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.mapIndexedTypes(mappedIndexManagerFactoryImpl);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.partiallyBuildAndAddTo(partiallyBuiltMappings);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            return new SearchIntegrationPartialBuildStateImpl(this.beanProvider, beanResolver, failureHandlerHolder, threadPoolProvider, partiallyBuiltMappings, indexManagerBuildingStateHolder.getBackendNonStartedStates(), indexManagerBuildingStateHolder.getIndexManagersNonStartedStates(), this.propertyChecker, engineThreads, timingSource);
        }
        catch (RuntimeException e) {
            Throwable rethrownException;
            if (checkingRootFailures) {
                rethrownException = e;
            } else {
                try {
                    failureCollector.checkNoFailure();
                    rethrownException = e;
                }
                catch (SearchException e2) {
                    rethrownException = e2;
                    rethrownException.addSuppressed(e);
                }
            }
            SuppressingCloser closer = new SuppressingCloser(rethrownException);
            closer.push(failureHandlerHolder);
            closer.pushAll(MappingPartialBuildState::closeOnFailure, partiallyBuiltMappings.values());
            closer.pushAll(MappingBuildingState::closeOnFailure, mappingBuildingStates);
            closer.pushAll(holder -> holder.closeOnFailure(closer), (Object[])new IndexManagerBuildingStateHolder[]{indexManagerBuildingStateHolder});
            closer.pushAll(BeanHolder::close, (Object[])new BeanHolder[]{threadProviderHolder});
            closer.pushAll(BeanProvider::close, (Object[])new BeanProvider[]{this.beanProvider});
            closer.push(EngineThreads::onStop, engineThreads);
            closer.push(TimingSource::stop, timingSource);
            throw rethrownException;
        }
    }

    private static class TypeMappingContribution<C> {
        private final List<C> contributors = new ArrayList<C>();

        TypeMappingContribution() {
        }

        void collectContributor(C contributor) {
            this.contributors.add(contributor);
        }

        Stream<C> getContributors() {
            return this.contributors.stream();
        }
    }

    private static class MappingBuildingState<C, PBM extends MappingPartialBuildState> {
        private final MappingBuildContext buildContext;
        private final MappingKey<PBM, ?> mappingKey;
        private final MappingInitiator<C, PBM> mappingInitiator;
        private final Map<MappableTypeModel, TypeMappingContribution<C>> contributionByType = new LinkedHashMap<MappableTypeModel, TypeMappingContribution<C>>();
        private final List<TypeMetadataDiscoverer<C>> metadataDiscoverers = new ArrayList<TypeMetadataDiscoverer<C>>();
        private final Set<MappableTypeModel> typesSubmittedToDiscoverers = new HashSet<MappableTypeModel>();
        private Mapper<PBM> mapper;

        MappingBuildingState(RootBuildContext rootBuildContext, MappingKey<PBM, ?> mappingKey, MappingInitiator<C, PBM> mappingInitiator) {
            this.mappingKey = mappingKey;
            this.buildContext = new MappingBuildContextImpl(rootBuildContext, mappingKey);
            this.mappingInitiator = mappingInitiator;
        }

        void collect() {
            this.mappingInitiator.configure(this.buildContext, new MappingConfigurationCollectorImpl());
        }

        void createMapper() {
            TypeMetadataContributorProviderImpl contributorProvider = new TypeMetadataContributorProviderImpl();
            this.mapper = this.mappingInitiator.createMapper(this.buildContext, contributorProvider);
        }

        void determineIndexedTypes(Set<Optional<String>> backendNames) {
            this.mapper.prepareIndexedTypes(backendNames::add);
        }

        void mapIndexedTypes(MappedIndexManagerFactory indexManagerFactory) {
            this.mapper.mapIndexedTypes(indexManagerFactory);
        }

        void partiallyBuildAndAddTo(Map<MappingKey<?, ?>, MappingPartialBuildState> mappings) {
            try {
                PBM partiallyBuiltMapping = this.mapper.prepareBuild();
                mappings.put(this.mappingKey, (MappingPartialBuildState)partiallyBuiltMapping);
            }
            catch (MappingAbortedException e) {
                this.handleMappingAborted(e);
            }
        }

        private TypeMappingContribution<C> getOrCreateContribution(MappableTypeModel typeModel) {
            TypeMappingContribution<C> contribution = this.contributionByType.get(typeModel);
            if (contribution == null) {
                contribution = new TypeMappingContribution();
                this.contributionByType.put(typeModel, contribution);
            }
            return contribution;
        }

        private TypeMappingContribution<C> getContributionIncludingAutomaticallyDiscovered(MappableTypeModel typeModel) {
            if (!this.typesSubmittedToDiscoverers.contains(typeModel)) {
                for (TypeMetadataDiscoverer<C> metadataDiscoverer : this.metadataDiscoverers) {
                    Optional<C> discoveredContributor = metadataDiscoverer.discover(typeModel);
                    if (!discoveredContributor.isPresent()) continue;
                    this.getOrCreateContribution(typeModel).collectContributor(discoveredContributor.get());
                }
                this.typesSubmittedToDiscoverers.add(typeModel);
            }
            return this.contributionByType.get(typeModel);
        }

        public void closeOnFailure() {
            if (this.mapper != null) {
                this.mapper.closeOnFailure();
            }
        }

        private void handleMappingAborted(MappingAbortedException e) {
            Throwable[] suppressed;
            ContextualFailureCollector failureCollector = this.buildContext.failureCollector();
            if (!failureCollector.hasFailure()) {
                throw new AssertionFailure("Caught " + MappingAbortedException.class.getSimpleName() + ", but the mapper did not collect any failure. There is a bug in the mapper, please report it.", (Throwable)e);
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                failureCollector.add(cause);
            }
            for (Throwable throwable : suppressed = e.getSuppressed()) {
                failureCollector.add(throwable);
            }
        }

        private class TypeMetadataContributorProviderImpl
        implements TypeMetadataContributorProvider<C> {
            private TypeMetadataContributorProviderImpl() {
            }

            @Override
            public Set<C> get(MappableTypeModel typeModel) {
                return typeModel.descendingSuperTypes().map(x$0 -> MappingBuildingState.this.getContributionIncludingAutomaticallyDiscovered(x$0)).filter(Objects::nonNull).flatMap(TypeMappingContribution::getContributors).collect(Collectors.toCollection(LinkedHashSet::new));
            }

            @Override
            public Set<? extends MappableTypeModel> typesContributedTo() {
                return Collections.unmodifiableSet(new LinkedHashSet(MappingBuildingState.this.contributionByType.keySet()));
            }
        }

        private class MappingConfigurationCollectorImpl
        implements MappingConfigurationCollector<C> {
            private MappingConfigurationCollectorImpl() {
            }

            @Override
            public void collectContributor(MappableTypeModel typeModel, C contributor) {
                MappingBuildingState.this.getOrCreateContribution(typeModel).collectContributor(contributor);
            }

            @Override
            public void collectDiscoverer(TypeMetadataDiscoverer<C> metadataDiscoverer) {
                MappingBuildingState.this.metadataDiscoverers.add(metadataDiscoverer);
            }
        }
    }
}

