/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.common.impl.MappingPreStopContextImpl;
import org.hibernate.search.engine.common.resources.impl.EngineThreads;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.thread.impl.ThreadPoolProviderImpl;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SearchIntegrationImpl
implements SearchIntegration {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanProvider beanProvider;
    private final BeanHolder<? extends FailureHandler> failureHandlerHolder;
    private final ThreadPoolProviderImpl threadPoolProvider;
    private final Map<MappingKey<?, ?>, MappingImplementor<?>> mappings;
    private final Map<String, BackendImplementor> backends;
    private final Map<String, IndexManagerImplementor> indexManagers;
    private final EngineThreads engineThreads;
    private final TimingSource timingSource;

    SearchIntegrationImpl(BeanProvider beanProvider, BeanHolder<? extends FailureHandler> failureHandlerHolder, ThreadPoolProviderImpl threadPoolProvider, Map<MappingKey<?, ?>, MappingImplementor<?>> mappings, Map<String, BackendImplementor> backends, Map<String, IndexManagerImplementor> indexManagers, EngineThreads engineThreads, TimingSource timingSource) {
        this.beanProvider = beanProvider;
        this.failureHandlerHolder = failureHandlerHolder;
        this.threadPoolProvider = threadPoolProvider;
        this.mappings = mappings;
        this.backends = backends;
        this.indexManagers = indexManagers;
        this.engineThreads = engineThreads;
        this.timingSource = timingSource;
    }

    @Override
    public Backend backend() {
        BackendImplementor backend = this.backends.get(null);
        if (backend == null) {
            throw log.noDefaultBackendRegistered();
        }
        return backend.toAPI();
    }

    @Override
    public Backend backend(String backendName) {
        BackendImplementor backend = this.backends.get(backendName);
        if (backend == null) {
            throw log.noBackendRegistered(backendName);
        }
        return backend.toAPI();
    }

    @Override
    public IndexManager indexManager(String indexManagerName) {
        IndexManagerImplementor indexManager = this.indexManagers.get(indexManagerName);
        if (indexManager == null) {
            throw log.noIndexManagerRegistered(indexManagerName);
        }
        return indexManager.toAPI();
    }

    @Override
    public void close() {
        RootFailureCollector failureCollector = new RootFailureCollector(EngineEventContextMessages.INSTANCE.shutdown());
        try (Closer closer = new Closer();){
            closer.push(this::preStopMappings, (Object)failureCollector);
            closer.pushAll(MappingImplementor::stop, this.mappings.values());
            closer.push(SearchIntegrationImpl::preStopIndexManagers, (Object)this);
            closer.pushAll(IndexManagerImplementor::stop, this.indexManagers.values());
            closer.push(SearchIntegrationImpl::preStopBackends, (Object)this);
            closer.pushAll(BackendImplementor::stop, this.backends.values());
            closer.pushAll(ThreadPoolProviderImpl::close, (Object[])new ThreadPoolProviderImpl[]{this.threadPoolProvider});
            closer.pushAll(BeanHolder::close, (Object[])new BeanHolder[]{this.failureHandlerHolder});
            closer.pushAll(BeanProvider::close, (Object[])new BeanProvider[]{this.beanProvider});
            closer.pushAll(EngineThreads::onStop, (Object[])new EngineThreads[]{this.engineThreads});
            closer.pushAll(TimingSource::stop, (Object[])new TimingSource[]{this.timingSource});
        }
        catch (RuntimeException e) {
            failureCollector.withContext(EventContexts.defaultContext()).add(e);
        }
        failureCollector.checkNoFailure();
    }

    private void preStopMappings(RootFailureCollector failureCollector) {
        CompletableFuture[] futures = new CompletableFuture[this.mappings.size()];
        int i = 0;
        for (Map.Entry<MappingKey<?, ?>, MappingImplementor<?>> entry : this.mappings.entrySet()) {
            MappingPreStopContextImpl preStopContext = new MappingPreStopContextImpl(failureCollector.withContext(entry.getKey()));
            futures[i] = entry.getValue().preStop(preStopContext);
            ++i;
        }
        Futures.unwrappedExceptionJoin(CompletableFuture.allOf(futures));
    }

    private void preStopIndexManagers() {
        CompletableFuture[] futures = new CompletableFuture[this.indexManagers.size()];
        int i = 0;
        for (IndexManagerImplementor indexManager : this.indexManagers.values()) {
            futures[i] = indexManager.preStop();
            ++i;
        }
        Futures.unwrappedExceptionJoin(CompletableFuture.allOf(futures));
    }

    private void preStopBackends() {
        CompletableFuture[] futures = new CompletableFuture[this.backends.size()];
        int i = 0;
        for (BackendImplementor backend : this.backends.values()) {
            futures[i] = backend.preStop();
            ++i;
        }
        Futures.unwrappedExceptionJoin(CompletableFuture.allOf(futures));
    }
}

