/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.loading.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class DefaultProjectionHitMapper<R, E>
implements ProjectionHitMapper<R, E> {
    private final DocumentReferenceConverter<R> documentReferenceConverter;
    private final EntityLoader<R, ? extends E> objectLoader;
    private final List<DocumentReference> referencesToLoad = new ArrayList<DocumentReference>();

    public DefaultProjectionHitMapper(DocumentReferenceConverter<R> documentReferenceConverter, EntityLoader<R, ? extends E> objectLoader) {
        this.documentReferenceConverter = documentReferenceConverter;
        this.objectLoader = objectLoader;
    }

    @Override
    public Object planLoading(DocumentReference reference) {
        this.referencesToLoad.add(reference);
        return this.referencesToLoad.size() - 1;
    }

    @Override
    public LoadingResult<R, E> loadBlocking(TimeoutManager timeoutManager) {
        List converted = this.referencesToLoad.stream().map(this.documentReferenceConverter::fromDocumentReference).collect(Collectors.toList());
        return new DefaultLoadingResult(this.objectLoader.loadBlocking(converted, timeoutManager), this.documentReferenceConverter);
    }

    private static class DefaultLoadingResult<R, E>
    implements LoadingResult<R, E> {
        private final List<? extends E> loadedObjects;
        private final DocumentReferenceConverter<R> documentReferenceConverter;

        private DefaultLoadingResult(List<? extends E> loadedObjects, DocumentReferenceConverter<R> documentReferenceConverter) {
            this.loadedObjects = CollectionHelper.toImmutableList(loadedObjects);
            this.documentReferenceConverter = documentReferenceConverter;
        }

        @Override
        public E get(Object key) {
            return this.loadedObjects.get((Integer)key);
        }

        @Override
        public R convertReference(DocumentReference reference) {
            return this.documentReferenceConverter.fromDocumentReference(reference);
        }
    }
}

