/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.timeout.spi;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class TimeoutManager {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final TimingSource timingSource;
    protected final Long timeoutMs;
    protected final Type type;
    private Long start;
    boolean timedOut = false;

    public TimeoutManager(TimingSource timingSource, Long timeoutMs, Type type) {
        this.timingSource = timingSource;
        this.timeoutMs = timeoutMs;
        this.type = type;
        timingSource.ensureInitialized();
    }

    public void start() {
        this.start = this.timingSource.monotonicTimeEstimate();
    }

    public void stop() {
        this.start = null;
    }

    public Long remainingTimeToHardTimeout() {
        if (!Type.EXCEPTION.equals((Object)this.type)) {
            return null;
        }
        return this.checkTimeLeftInMilliseconds();
    }

    public long timeoutBaseline() {
        return this.start;
    }

    public Long checkTimeLeftInMilliseconds() {
        if (this.timeoutMs == null) {
            return null;
        }
        long elapsedTime = this.elapsedTimeInMilliseconds();
        long timeLeft = this.timeoutMs - elapsedTime;
        if (timeLeft <= 0L) {
            this.forceTimedOut();
            return 0L;
        }
        return timeLeft;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public boolean checkTimedOut() {
        Long timeLeft = this.checkTimeLeftInMilliseconds();
        return timeLeft != null && timeLeft <= 0L;
    }

    public void forceTimedOut() {
        this.timedOut = Boolean.TRUE;
        this.onTimedOut();
    }

    public boolean hasHardTimeout() {
        return this.type == Type.EXCEPTION;
    }

    public Duration tookTime() {
        return Duration.ofMillis(this.elapsedTimeInMilliseconds());
    }

    protected void onTimedOut() {
        throw log.timedOut(this.timeoutMs);
    }

    protected long elapsedTimeInMilliseconds() {
        return this.timingSource.monotonicTimeEstimate() - this.start;
    }

    public static enum Type {
        NONE,
        EXCEPTION,
        LIMIT;

    }
}

