/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.impl.EngineConfigurationUtils;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.impl.BackendBuildContextImpl;
import org.hibernate.search.engine.common.impl.BackendPartialBuildState;
import org.hibernate.search.engine.common.impl.IndexManagerPartialBuildState;
import org.hibernate.search.engine.common.impl.RootBuildContext;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.building.impl.IndexManagerBuildingState;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class IndexManagerBuildingStateHolder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<String> DEFAULT_INDEX_BACKEND_NAME = ConfigurationProperty.forKey("default_backend").asString().build();
    private static final OptionalConfigurationProperty<BeanReference<? extends BackendFactory>> BACKEND_TYPE = ConfigurationProperty.forKey("type").asBeanReference(BackendFactory.class).build();
    private final BeanResolver beanResolver;
    private final ConfigurationPropertySource propertySource;
    private final RootBuildContext rootBuildContext;
    private final Map<String, BackendInitialBuildState<?>> backendBuildStateByName = new LinkedHashMap();
    private final Map<String, IndexManagerInitialBuildState<?>> indexManagerBuildStateByName = new LinkedHashMap();

    IndexManagerBuildingStateHolder(BeanResolver beanResolver, ConfigurationPropertySource propertySource, RootBuildContext rootBuildContext) {
        this.beanResolver = beanResolver;
        this.propertySource = propertySource;
        this.rootBuildContext = rootBuildContext;
    }

    void createBackends(Set<Optional<String>> backendNames) {
        if (backendNames.remove(Optional.empty())) {
            backendNames.add(Optional.of(this.getDefaultBackendName()));
        }
        for (Optional<String> backendNameOptional : backendNames) {
            BackendInitialBuildState<?> backendBuildState;
            String backendName = backendNameOptional.get();
            try {
                backendBuildState = this.createBackend(backendName);
            }
            catch (RuntimeException e) {
                this.rootBuildContext.getFailureCollector().withContext(EventContexts.fromBackendName(backendName)).add(e);
                continue;
            }
            this.backendBuildStateByName.put(backendName, backendBuildState);
        }
    }

    IndexManagerBuildingState<?> getIndexManagerBuildingState(Optional<String> backendName, String indexName, boolean multiTenancyEnabled) {
        return this.getBackend(backendName.orElseGet(this::getDefaultBackendName)).getIndexManagerBuildingState(indexName, multiTenancyEnabled);
    }

    private BackendInitialBuildState<?> getBackend(String backendName) {
        BackendInitialBuildState<?> backendBuildState = this.backendBuildStateByName.get(backendName);
        if (backendBuildState == null) {
            throw new AssertionFailure("Mapper asking for a reference to backend '" + backendName + "', which was not declared in advance. There is a bug in Hibernate Search, please report it.");
        }
        return backendBuildState;
    }

    private String getDefaultBackendName() {
        Optional defaultBackendNameOptional = (Optional)DEFAULT_INDEX_BACKEND_NAME.get(this.propertySource);
        if (defaultBackendNameOptional.isPresent()) {
            return (String)defaultBackendNameOptional.get();
        }
        throw log.defaultBackendNameNotSet(DEFAULT_INDEX_BACKEND_NAME.resolveOrRaw(this.propertySource));
    }

    Map<String, BackendPartialBuildState> getBackendPartialBuildStates() {
        LinkedHashMap<String, BackendPartialBuildState> backendsByName = new LinkedHashMap<String, BackendPartialBuildState>();
        for (Map.Entry<String, BackendInitialBuildState<?>> entry : this.backendBuildStateByName.entrySet()) {
            backendsByName.put(entry.getKey(), entry.getValue().getPartiallyBuilt());
        }
        return backendsByName;
    }

    Map<String, IndexManagerPartialBuildState> getIndexManagersByName() {
        LinkedHashMap<String, IndexManagerPartialBuildState> indexManagersByName = new LinkedHashMap<String, IndexManagerPartialBuildState>();
        for (Map.Entry<String, IndexManagerInitialBuildState<?>> entry : this.indexManagerBuildStateByName.entrySet()) {
            indexManagersByName.put(entry.getKey(), entry.getValue().getPartialBuildState());
        }
        return indexManagersByName;
    }

    void closeOnFailure(SuppressingCloser closer) {
        closer.pushAll(state -> state.closeOnFailure(closer), this.indexManagerBuildStateByName.values());
        closer.pushAll(BackendInitialBuildState::closeOnFailure, this.backendBuildStateByName.values());
    }

    private BackendInitialBuildState<?> createBackend(String backendName) {
        ConfigurationPropertySource backendPropertySource = EngineConfigurationUtils.getBackend(this.propertySource, backendName);
        try (BeanHolder backendFactoryHolder = BACKEND_TYPE.getAndMapOrThrow(backendPropertySource, this.beanResolver::resolve, key -> log.backendTypeCannotBeNullOrEmpty(backendName, (String)key));){
            BackendBuildContextImpl backendBuildContext = new BackendBuildContextImpl(this.rootBuildContext);
            BackendImplementor<?> backend = ((BackendFactory)backendFactoryHolder.get()).create(backendName, backendBuildContext, backendPropertySource);
            BackendInitialBuildState backendInitialBuildState = new BackendInitialBuildState(backendName, backendBuildContext, backendPropertySource, backend);
            return backendInitialBuildState;
        }
    }

    private class IndexManagerInitialBuildState<D extends DocumentElement>
    implements IndexManagerBuildingState<D> {
        private final String backendName;
        private final String indexName;
        private final IndexManagerBuilder<D> builder;
        private final IndexSchemaRootNodeBuilder schemaRootNodeBuilder;
        private IndexManagerImplementor<D> indexManager;

        IndexManagerInitialBuildState(String backendName, String indexName, IndexManagerBuilder<D> builder, IndexSchemaRootNodeBuilder schemaRootNodeBuilder) {
            this.backendName = backendName;
            this.indexName = indexName;
            this.builder = builder;
            this.schemaRootNodeBuilder = schemaRootNodeBuilder;
        }

        void closeOnFailure(SuppressingCloser closer) {
            if (this.indexManager != null) {
                closer.push(IndexManagerImplementor::stop, this.indexManager);
            } else {
                closer.push(IndexManagerBuilder::closeOnFailure, this.builder);
            }
        }

        @Override
        public String getIndexName() {
            return this.indexName;
        }

        @Override
        public IndexSchemaRootNodeBuilder getSchemaRootNodeBuilder() {
            return this.schemaRootNodeBuilder;
        }

        @Override
        public IndexManagerImplementor<D> build() {
            if (this.indexManager != null) {
                throw new AssertionFailure("Trying to build index manager " + this.indexName + " twice. There is probably a bug in the mapper implementation.");
            }
            this.indexManager = this.builder.build();
            return this.indexManager;
        }

        IndexManagerPartialBuildState getPartialBuildState() {
            if (this.indexManager == null) {
                throw new AssertionFailure("Index manager " + this.indexName + " was not built by the mapper as expected. There is probably a bug in the mapper implementation.");
            }
            return new IndexManagerPartialBuildState(this.backendName, this.indexName, this.indexManager);
        }
    }

    class BackendInitialBuildState<D extends DocumentElement> {
        private final String backendName;
        private final BackendBuildContext backendBuildContext;
        private final ConfigurationPropertySource backendPropertySource;
        private final ConfigurationPropertySource defaultIndexPropertySource;
        private final BackendImplementor<D> backend;

        private BackendInitialBuildState(String backendName, BackendBuildContext backendBuildContext, ConfigurationPropertySource backendPropertySource, BackendImplementor<D> backend) {
            this.backendName = backendName;
            this.backendBuildContext = backendBuildContext;
            this.backendPropertySource = backendPropertySource;
            this.defaultIndexPropertySource = EngineConfigurationUtils.getIndexDefaults(backendPropertySource);
            this.backend = backend;
        }

        IndexManagerInitialBuildState<?> getIndexManagerBuildingState(String indexName, boolean multiTenancyEnabled) {
            IndexManagerInitialBuildState<D> state = (IndexManagerInitialBuildState<D>)IndexManagerBuildingStateHolder.this.indexManagerBuildStateByName.get(indexName);
            if (state == null) {
                ConfigurationPropertySource indexPropertySource = EngineConfigurationUtils.getIndex(this.backendPropertySource, this.defaultIndexPropertySource, indexName);
                IndexManagerBuilder<D> builder = this.backend.createIndexManagerBuilder(indexName, multiTenancyEnabled, this.backendBuildContext, indexPropertySource);
                IndexSchemaRootNodeBuilder schemaRootNodeBuilder = builder.getSchemaRootNodeBuilder();
                state = new IndexManagerInitialBuildState<D>(this.backendName, indexName, builder, schemaRootNodeBuilder);
                IndexManagerBuildingStateHolder.this.indexManagerBuildStateByName.put(indexName, state);
            }
            return state;
        }

        void closeOnFailure() {
            this.backend.stop();
        }

        BackendPartialBuildState getPartiallyBuilt() {
            return new BackendPartialBuildState(this.backendName, this.backend);
        }
    }
}

