/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.engine.mapper.scope.impl.MappedIndexScopeBuilderImpl;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;

public class MappedIndexManagerImpl<D extends DocumentElement>
implements MappedIndexManager<D> {
    private final IndexManagerImplementor<D> implementor;

    public MappedIndexManagerImpl(IndexManagerImplementor<D> implementor) {
        this.implementor = implementor;
    }

    @Override
    public IndexManager toAPI() {
        return this.implementor.toAPI();
    }

    @Override
    public IndexIndexingPlan<D> createIndexingPlan(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.implementor.createIndexingPlan(sessionContext, commitStrategy, refreshStrategy);
    }

    @Override
    public IndexIndexer<D> createIndexer(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy) {
        return this.implementor.createIndexer(sessionContext, commitStrategy);
    }

    @Override
    public IndexWorkspace createWorkspace(DetachedBackendSessionContext sessionContext) {
        return this.implementor.createWorkspace(sessionContext);
    }

    @Override
    public <R, E> MappedIndexScopeBuilder<R, E> createScopeBuilder(BackendMappingContext mappingContext) {
        return new MappedIndexScopeBuilderImpl(this.implementor, mappingContext);
    }

    @Override
    public void addTo(MappedIndexScopeBuilder<?, ?> builder) {
        ((MappedIndexScopeBuilderImpl)builder).add(this.implementor);
    }
}

