/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.engine.reporting.FailureContext;

public class IndexFailureContext
extends FailureContext {
    private String indexName;
    private final List<Object> uncommittedOperations;

    public static Builder builder() {
        return new Builder();
    }

    private IndexFailureContext(Builder builder) {
        super(builder);
        this.indexName = builder.indexName == null ? "Unknown index" : builder.indexName;
        this.uncommittedOperations = builder.uncommittedOperations == null ? Collections.emptyList() : Collections.unmodifiableList(builder.uncommittedOperations);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<Object> getUncommittedOperations() {
        return this.uncommittedOperations;
    }

    public static class Builder
    extends FailureContext.Builder {
        private String indexName;
        private List<Object> uncommittedOperations;

        private Builder() {
        }

        public void indexName(String indexName) {
            this.indexName = indexName;
        }

        public void uncommittedOperation(Object uncommittedOperation) {
            if (this.uncommittedOperations == null) {
                this.uncommittedOperations = new ArrayList<Object>();
            }
            this.uncommittedOperations.add(uncommittedOperation);
        }

        @Override
        public IndexFailureContext build() {
            return new IndexFailureContext(this);
        }
    }
}

