/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.dsl.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.dsl.impl.DefaultSearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQueryHitTypeStep;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public final class DefaultSearchQueryHitTypeStep<R, E, LOS, C>
extends AbstractSearchQueryHitTypeStep<SearchQueryOptionsStep<?, E, LOS, ?, ?>, R, E, LOS, SearchProjectionFactory<R, E>, SearchPredicateFactory, C> {
    private final IndexScope<C> indexScope;
    private final BackendSessionContext sessionContext;
    private final LoadingContextBuilder<R, E, LOS> loadingContextBuilder;

    public DefaultSearchQueryHitTypeStep(IndexScope<C> indexScope, BackendSessionContext sessionContext, LoadingContextBuilder<R, E, LOS> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public DefaultSearchQueryOptionsStep<E, LOS, C> asEntity() {
        SearchQueryBuilder<E, C> builder = this.indexScope.getSearchQueryBuilderFactory().asEntity(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryOptionsStep<E, LOS, C>(this.indexScope, builder, this.loadingContextBuilder);
    }

    @Override
    public DefaultSearchQueryOptionsStep<R, LOS, C> asEntityReference() {
        SearchQueryBuilder<R, C> builder = this.indexScope.getSearchQueryBuilderFactory().asReference(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryOptionsStep<R, LOS, C>(this.indexScope, builder, this.loadingContextBuilder);
    }

    @Override
    public <P> DefaultSearchQueryOptionsStep<P, LOS, C> asProjection(Function<? super SearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        SearchProjectionFactory factory = this.createDefaultProjectionFactory();
        SearchProjection<P> projection = projectionContributor.apply(factory).toProjection();
        return this.asProjection((SearchProjection)projection);
    }

    @Override
    public <P> DefaultSearchQueryOptionsStep<P, LOS, C> asProjection(SearchProjection<P> projection) {
        SearchQueryBuilder<P, C> builder = this.indexScope.getSearchQueryBuilderFactory().asProjection(this.sessionContext, this.loadingContextBuilder, projection);
        return new DefaultSearchQueryOptionsStep<P, LOS, C>(this.indexScope, builder, this.loadingContextBuilder);
    }

    @Override
    public DefaultSearchQueryOptionsStep<List<?>, LOS, C> asProjections(SearchProjection<?> ... projections) {
        SearchQueryBuilder<List<R>, C> builder = this.indexScope.getSearchQueryBuilderFactory().asProjections(this.sessionContext, this.loadingContextBuilder, projections);
        return new DefaultSearchQueryOptionsStep<List<R>, LOS, C>(this.indexScope, builder, this.loadingContextBuilder);
    }

    @Override
    public SearchQueryOptionsStep<?, E, LOS, ?, ?> predicate(Function<? super SearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return ((AbstractSearchQueryOptionsStep)this.asEntity()).predicate(predicateContributor);
    }

    @Override
    public SearchQueryOptionsStep<?, E, LOS, ?, ?> predicate(SearchPredicate predicate) {
        return ((AbstractSearchQueryOptionsStep)this.asEntity()).predicate(predicate);
    }

    @Override
    protected IndexScope<C> getIndexScope() {
        return this.indexScope;
    }

    @Override
    protected BackendSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    protected LoadingContextBuilder<R, E, LOS> getLoadingContextBuilder() {
        return this.loadingContextBuilder;
    }
}

