/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.cfg.spi.AllAwareConfigurationPropertySource;

public class SystemConfigurationPropertySource
implements AllAwareConfigurationPropertySource {
    private static final SystemConfigurationPropertySource INSTANCE = new SystemConfigurationPropertySource();

    public static AllAwareConfigurationPropertySource get() {
        return INSTANCE;
    }

    private SystemConfigurationPropertySource() {
    }

    @Override
    public Optional<?> get(String key) {
        String value = System.getProperty(key);
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<String> resolve(String key) {
        return Optional.of(key);
    }

    @Override
    public Set<String> resolveAll(String prefix) {
        HashSet<String> prefixedPropertyKeys = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String stringKey;
            Object key = entry.getKey();
            if (!(key instanceof String) || !(stringKey = (String)key).startsWith(prefix)) continue;
            prefixedPropertyKeys.add(stringKey);
        }
        return prefixedPropertyKeys;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

