/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void startingExecutor(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingExecutor$str(), (Object)name);
    }

    protected String startingExecutor$str() {
        return "HSEARCH000230: Starting executor '%1$s'";
    }

    @Override
    public final void stoppingExecutor(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingExecutor$str(), (Object)indexName);
    }

    protected String stoppingExecutor$str() {
        return "HSEARCH000231: Stopping executor '%1$s'";
    }

    protected String noPublicNoArgConstructor$str() {
        return "HSEARCH000242: Hibernate Search failed to initialize component '%1$s' as class '%2$s' doesn't have a public no-arguments constructor";
    }

    @Override
    public final SearchException noPublicNoArgConstructor(String componentName, Class<?> clazz) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noPublicNoArgConstructor$str(), componentName, new ClassFormatter(clazz)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String simpleQueryStringCannotBeNull$str() {
        return "HSEARCH000334: Invalid simple query string: the string must be non-null. Null value was passed to simple query string predicate on fields %1$s.";
    }

    @Override
    public final SearchException simpleQueryStringCannotBeNull(Collection<String> strings) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.simpleQueryStringCannotBeNull$str(), strings));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToConvertConfigurationProperty$str() {
        return "HSEARCH000501: Unable to convert configuration property '%1$s' with value '%2$s': %3$s";
    }

    @Override
    public final SearchException unableToConvertConfigurationProperty(String key, Object rawValue, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToConvertConfigurationProperty$str(), key, rawValue, errorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPropertyValue$str() {
        return "HSEARCH000502: Invalid value: expected either an instance of '%1$s' or a String that can be parsed. %2$s";
    }

    @Override
    public final SearchException invalidPropertyValue(Class<?> expectedType, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPropertyValue$str(), new ClassFormatter(expectedType), errorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidBooleanPropertyValue$str() {
        return "HSEARCH000503: Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s";
    }

    @Override
    public final SearchException invalidBooleanPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBooleanPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIntegerPropertyValue$str() {
        return "HSEARCH000504: Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s";
    }

    @Override
    public final SearchException invalidIntegerPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIntegerPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidLongPropertyValue$str() {
        return "HSEARCH000505: Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s";
    }

    @Override
    public final SearchException invalidLongPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLongPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMultiPropertyValue$str() {
        return "HSEARCH000506: Invalid multi value: expected either a Collection or a String.";
    }

    @Override
    public final SearchException invalidMultiPropertyValue() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiPropertyValue$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddMultiplePredicatesToNestedPredicate$str() {
        return "HSEARCH000509: Cannot add multiple predicates to a nested predicate; use an explicit boolean predicate instead.";
    }

    @Override
    public final SearchException cannotAddMultiplePredicatesToNestedPredicate() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotAddMultiplePredicatesToNestedPredicate$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String matchPredicateCannotMatchNullValue$str() {
        return "HSEARCH000511: Invalid value: the value to match in match predicates must be non-null.";
    }

    @Override
    public final SearchException matchPredicateCannotMatchNullValue(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.matchPredicateCannotMatchNullValue$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rangePredicateCannotMatchNullValue$str() {
        return "HSEARCH000512: Invalid value: at least one bound in range predicates must be non-null.";
    }

    @Override
    public final SearchException rangePredicateCannotMatchNullValue(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangePredicateCannotMatchNullValue$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String relativeFieldNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000514: Field name '%1$s' is invalid: field names cannot be null or empty.";
    }

    @Override
    public final SearchException relativeFieldNameCannotBeNullOrEmpty(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeFieldNameCannotBeNullOrEmpty$str(), relativeFieldName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String relativeFieldNameCannotContainDot$str() {
        return "HSEARCH000515: Field name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.";
    }

    @Override
    public final SearchException relativeFieldNameCannotContainDot(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeFieldNameCannotContainDot$str(), relativeFieldName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str() {
        return "HSEARCH000516: Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.";
    }

    @Override
    public final IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(GeoPoint firstPoint, GeoPoint lastPoint) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str(), firstPoint, lastPoint));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String collectedFailureLimitReached$str() {
        return "HSEARCH000519: Hibernate Search encountered failures during %1$s. Stopped collecting failures after '%3$s' failures. Failures:\n%2$s";
    }

    @Override
    public final SearchException collectedFailureLimitReached(String process, String renderedFailures, int failureCount) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.collectedFailureLimitReached$str(), process, renderedFailures, failureCount));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String collectedFailures$str() {
        return "HSEARCH000520: Hibernate Search encountered failures during %1$s. Failures:\n%2$s";
    }

    @Override
    public final SearchException collectedFailures(String process, String renderedFailures) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.collectedFailures$str(), process, renderedFailures));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void newCollectedFailure(String process, String context, Throwable failure) {
        this.log.logf(FQCN, Logger.Level.ERROR, failure, this.newCollectedFailure$str(), (Object)process, (Object)context);
    }

    protected String newCollectedFailure$str() {
        return "HSEARCH000521: Hibernate Search encountered a failure during %1$s; continuing for now to list all problems, but the process will ultimately be aborted.\nContext: %2$s\nFailure:";
    }

    @Override
    public final void unexpectedEmptyEventContext(Throwable exceptionForStackTrace) {
        this.log.logf(FQCN, Logger.Level.DEBUG, exceptionForStackTrace, this.unexpectedEmptyEventContext$str(), new Object[0]);
    }

    protected String unexpectedEmptyEventContext$str() {
        return "HSEARCH000522: Unexpected empty event context; there is a bug in Hibernate Search, please report it";
    }

    protected String cannotCallDslExtensionIfSupportedAfterOrElse$str() {
        return "HSEARCH000525: Cannot call ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.";
    }

    @Override
    public final SearchException cannotCallDslExtensionIfSupportedAfterOrElse() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCallDslExtensionIfSupportedAfterOrElse$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String dslExtensionNoMatch$str() {
        return "HSEARCH000526: None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).";
    }

    @Override
    public final SearchException dslExtensionNoMatch(List<?> attemptedExtensions) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.dslExtensionNoMatch$str(), attemptedExtensions));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInstantiateComponent$str() {
        return "HSEARCH000527: Unable to instantiate %1$s, class '%2$s': %3$s";
    }

    @Override
    public final SearchException unableToInstantiateComponent(String componentDescription, Class<?> classToLoad, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInstantiateComponent$str(), componentDescription, new ClassFormatter(classToLoad), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityManagerLoadingError$str() {
        return "HSEARCH000528: %2$s defined for component %1$s could not be instantiated because of a security manager error";
    }

    @Override
    public final SearchException securityManagerLoadingError(String componentDescription, Class<?> classToLoad, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.securityManagerLoadingError$str(), componentDescription, new ClassFormatter(classToLoad)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToFindComponentImplementation$str() {
        return "HSEARCH000529: Unable to find %1$s implementation class: %2$s";
    }

    @Override
    public final SearchException unableToFindComponentImplementation(String componentDescription, String classNameToLoad, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToFindComponentImplementation$str(), componentDescription, classNameToLoad), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadTheClass$str() {
        return "HSEARCH000530: Unable to load class [%1$s]";
    }

    @Override
    public final ClassLoadingException unableToLoadTheClass(String className, Throwable cause) {
        ClassLoadingException result = new ClassLoadingException(String.format(this.getLoggingLocale(), this.unableToLoadTheClass$str(), className), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String noBackendRegistered$str() {
        return "HSEARCH000533: No backend registered for backend name: '%1$s'.";
    }

    @Override
    public final SearchException noBackendRegistered(String backendName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noBackendRegistered$str(), backendName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noIndexManagerRegistered$str() {
        return "HSEARCH000534: No index manager registered for index manager name: '%1$s'.";
    }

    @Override
    public final SearchException noIndexManagerRegistered(String indexManagerName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noIndexManagerRegistered$str(), indexManagerName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInstantiateClass$str() {
        return "HSEARCH000540: Unable to instantiate class '%1$s': %2$s.";
    }

    @Override
    public final SearchException unableToInstantiateClass(Class<?> classToLoad, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInstantiateClass$str(), new ClassFormatter(classToLoad), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interfaceImplementedExpected$str() {
        return "HSEARCH000541: Wrong configuration of %1$s: class %2$s does not implement interface %3$s.";
    }

    @Override
    public final SearchException interfaceImplementedExpected(String component, Class<?> classToLoad, Class<?> superType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.interfaceImplementedExpected$str(), component, new ClassFormatter(classToLoad), new ClassFormatter(superType)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String subtypeExpected$str() {
        return "HSEARCH000542: Wrong configuration of %1$s: class %2$s is not a subtype of %3$s.";
    }

    @Override
    public final SearchException subtypeExpected(String component, Class<?> classToLoad, Class<?> superType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.subtypeExpected$str(), component, new ClassFormatter(classToLoad), new ClassFormatter(superType)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String implementationRequired$str() {
        return "HSEARCH000543: %2$s defined for component %1$s is an interface: implementation required.";
    }

    @Override
    public final SearchException implementationRequired(String component, Class<?> classToLoad) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.implementationRequired$str(), component, new ClassFormatter(classToLoad)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingConstructor$str() {
        return "HSEARCH000544: %2$s defined for component %1$s is missing an appropriate constructor: expected a public constructor with a single parameter of type Map.";
    }

    @Override
    public final SearchException missingConstructor(String component, Class<?> classToLoad) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingConstructor$str(), component, new ClassFormatter(classToLoad)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAssignableImplementation$str() {
        return "HSEARCH000545: Unable to load class for %1$s. Configured implementation %2$s  is not assignable to type %3$s.";
    }

    @Override
    public final SearchException notAssignableImplementation(String component, String classToLoad, Class<?> superType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notAssignableImplementation$str(), component, classToLoad, new ClassFormatter(superType)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexedEmbeddedCyclicRecursion$str() {
        return "HSEARCH000546: Found an infinite IndexedEmbedded recursion involving path '%1$s' on type '%2$s'.";
    }

    @Override
    public final SearchException indexedEmbeddedCyclicRecursion(String cyclicRecursionPath, MappableTypeModel parentTypeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexedEmbeddedCyclicRecursion$str(), cyclicRecursionPath, new MappableTypeModelFormatter(parentTypeModel)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidBeanReferencePropertyValue$str() {
        return "HSEARCH000547: Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s";
    }

    @Override
    public final SearchException invalidBeanReferencePropertyValue(Class<?> expectedType, String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBeanReferencePropertyValue$str(), new ClassFormatter(expectedType), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidBeanType$str() {
        return "HSEARCH000548: Invalid bean type: type '%2$s' is not assignable to '%1$s'.";
    }

    @Override
    public final SearchException invalidBeanType(Class<?> expectedSuperType, Class<?> actualType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBeanType$str(), new ClassFormatter(expectedSuperType), new ClassFormatter(actualType)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String backendTypeCannotBeNullOrEmpty$str() {
        return "HSEARCH000549: Missing backend type for backend '%1$s'. Set the property '%2$s' to a supported value.";
    }

    @Override
    public final SearchException backendTypeCannotBeNullOrEmpty(String backendName, String key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendTypeCannotBeNullOrEmpty$str(), backendName, key));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String defaultBackendNameNotSet$str() {
        return "HSEARCH000550: The name of the default backend is not set. Set it through the configuration property '%1$s', or set the backend name explicitly for each indexed type in your mapping.";
    }

    @Override
    public final SearchException defaultBackendNameNotSet(String defaultKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.defaultBackendNameNotSet$str(), defaultKey));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String perFieldBoostWithConstantScore$str() {
        return "HSEARCH000551: It is not possible to use per-field boosts together with withConstantScore option";
    }

    @Override
    public final SearchException perFieldBoostWithConstantScore() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.perFieldBoostWithConstantScore$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String phrasePredicateCannotMatchNullPhrase$str() {
        return "HSEARCH000552: Invalid phrase: the phrase to match in phrase predicates must be non-null.";
    }

    @Override
    public final SearchException phrasePredicateCannotMatchNullPhrase(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.phrasePredicateCannotMatchNullPhrase$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPhrasePredicateSlop$str() {
        return "HSEARCH000553: Invalid slop: %1$d. The slop must be positive or zero.";
    }

    @Override
    public final SearchException invalidPhrasePredicateSlop(int slop) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPhrasePredicateSlop$str(), slop));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFuzzyMaximumEditDistance$str() {
        return "HSEARCH000554: Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.";
    }

    @Override
    public final SearchException invalidFuzzyMaximumEditDistance(int maximumEditDistance) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFuzzyMaximumEditDistance$str(), maximumEditDistance));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidExactPrefixLength$str() {
        return "HSEARCH000555: Invalid exact prefix length: %1$d. The value must be positive or zero.";
    }

    @Override
    public final SearchException invalidExactPrefixLength(int exactPrefixLength) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidExactPrefixLength$str(), exactPrefixLength));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wildcardPredicateCannotMatchNullPattern$str() {
        return "HSEARCH000556: Invalid pattern: the pattern to match in wildcard predicates must be non-null.";
    }

    @Override
    public final SearchException wildcardPredicateCannotMatchNullPattern(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.wildcardPredicateCannotMatchNullPattern$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseTemporal$str() {
        return "HSEARCH000557: '%1$s' instance cannot be parsed from value: '%2$s', using the expected formatter: '%3$s'.";
    }

    @Override
    public final SearchException unableToParseTemporal(Class<? extends TemporalAccessor> type, String value, DateTimeFormatter formatter, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseTemporal$str(), new SimpleNameClassFormatter(type), value, formatter), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNumberPropertyValue$str() {
        return "HSEARCH000558: Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s";
    }

    @Override
    public final SearchException invalidNumberPropertyValue(Class<? extends Number> type, String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidNumberPropertyValue$str(), new SimpleNameClassFormatter(type), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStringForType$str() {
        return "HSEARCH000559: Invalid '%1$s' value for type '%2$s'.";
    }

    @Override
    public final SearchException invalidStringForType(String value, Class<?> type, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidStringForType$str(), value, new ClassFormatter(type)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStringForEnum$str() {
        return "HSEARCH000560: Invalid '%1$s' value for enum '%2$s'.";
    }

    @Override
    public final SearchException invalidStringForEnum(String value, Class<? extends Enum> enumType, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidStringForEnum$str(), value, new ClassFormatter(enumType)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonSingleHit$str() {
        return "HSEARCH000561: Multiple hits when a single hit was expected: got %1$s hits.";
    }

    @Override
    public final SearchException nonSingleHit(long totalHitCount) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonSingleHit$str(), totalHitCount));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String threadInterruptedWhileSubmittingWork$str() {
        return "HSEARCH000562: The thread was interrupted while a work was being submitted to '%1$s'. The work has been discarded.";
    }

    @Override
    public final SearchException threadInterruptedWhileSubmittingWork(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.threadInterruptedWhileSubmittingWork$str(), orchestratorName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String submittedWorkToStoppedOrchestrator$str() {
        return "HSEARCH000563: A work was submitted to '%1$s', but this orchestrator was stopped. The work has been discarded.";
    }

    @Override
    public final SearchException submittedWorkToStoppedOrchestrator(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.submittedWorkToStoppedOrchestrator$str(), orchestratorName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseGeoPoint$str() {
        return "HSEARCH000564: Unable to parse the provided geo-point value: '%1$s'. The expected format is latitude, longitude.";
    }

    @Override
    public final SearchException unableToParseGeoPoint(String value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseGeoPoint$str(), value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAggregationKey$str() {
        return "HSEARCH000565: Unknown aggregation key '%1$s'. This key was not used when building the search query.";
    }

    @Override
    public final SearchException unknownAggregationKey(AggregationKey<?> key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAggregationKey$str(), key));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidConfigurationPropertyCheckingStrategyName$str() {
        return "HSEARCH000566: Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidConfigurationPropertyCheckingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidConfigurationPropertyCheckingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void configurationPropertyTrackingDisabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configurationPropertyTrackingDisabled$str(), new Object[0]);
    }

    protected String configurationPropertyTrackingDisabled$str() {
        return "HSEARCH000567: Configuration property tracking is disabled; unused properties will not be logged.";
    }

    @Override
    public final void configurationPropertyTrackingUnusedProperties(Set<String> propertyKeys, String disableWarningKey, String disableWarningValue) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configurationPropertyTrackingUnusedProperties$str(), propertyKeys, (Object)disableWarningKey, (Object)disableWarningValue);
    }

    protected String configurationPropertyTrackingUnusedProperties$str() {
        return "HSEARCH000568: Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.";
    }

    @Override
    public final void failureInFailureHandler(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failureInFailureHandler$str(), new Object[0]);
    }

    protected String failureInFailureHandler$str() {
        return "HSEARCH000569: The background failure handler threw an exception while handling a previous failure. The failure may not have been reported.";
    }
}

